"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ReferenceResponseDocType = Literal[
    "HTML",
    "Doc",
    "PDF",
]
r"""Format of the source document (HTML, Doc, or PDF)."""


ReferenceResponseSource = Literal[
    "eGain Article",
    "eGain Attachment",
]
r"""Source Type"""


class ReferenceResponseLinkTypedDict(TypedDict):
    r"""Defines the relationship between this resource and another object."""

    rel: NotRequired[str]
    r"""Defines the relationship between a linked resource and the current object. <br><br> For example: self, prev, next or an object name such as 'user', 'folder' etc."""
    href: NotRequired[str]
    r"""The URL that specifies the link's destination."""


class ReferenceResponseLink(BaseModel):
    r"""Defines the relationship between this resource and another object."""

    rel: Optional[str] = None
    r"""Defines the relationship between a linked resource and the current object. <br><br> For example: self, prev, next or an object name such as 'user', 'folder' etc."""

    href: Optional[str] = None
    r"""The URL that specifies the link's destination."""


class ReferenceResponseTypedDict(TypedDict):
    r"""One document used in generated response"""

    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    name: str
    r"""The name of the Article or source content."""
    doc_type: ReferenceResponseDocType
    r"""Format of the source document (HTML, Doc, or PDF)."""
    source: ReferenceResponseSource
    r"""Source Type"""
    doc_name: NotRequired[str]
    r"""Name of the attachment, if an attachment was used as the source content."""
    link: NotRequired[ReferenceResponseLinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class ReferenceResponse(BaseModel):
    r"""One document used in generated response"""

    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    name: str
    r"""The name of the Article or source content."""

    doc_type: Annotated[ReferenceResponseDocType, pydantic.Field(alias="docType")]
    r"""Format of the source document (HTML, Doc, or PDF)."""

    source: ReferenceResponseSource
    r"""Source Type"""

    doc_name: Annotated[Optional[str], pydantic.Field(alias="docName")] = None
    r"""Name of the attachment, if an attachment was used as the source content."""

    link: Optional[ReferenceResponseLink] = None
    r"""Defines the relationship between this resource and another object."""
