"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


RetrieveRequestType = Literal[
    "portal",
    "custom",
]
r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""


class RetrieveRequestChannelTypedDict(TypedDict):
    type: NotRequired[RetrieveRequestType]
    r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""
    name: NotRequired[str]
    r"""A descriptive name for the channel (e.g., \"web\", \"mobile app\", \"agent console\")."""


class RetrieveRequestChannel(BaseModel):
    type: Optional[RetrieveRequestType] = "custom"
    r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""

    name: Optional[str] = None
    r"""A descriptive name for the channel (e.g., \"web\", \"mobile app\", \"agent console\")."""


class RetrieveRequestTypedDict(TypedDict):
    channel: NotRequired[RetrieveRequestChannelTypedDict]
    event_id: NotRequired[str]
    r"""Unique ID for this specific API call or event."""
    session_id: NotRequired[str]
    r"""ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session."""


class RetrieveRequest(BaseModel):
    channel: Optional[RetrieveRequestChannel] = None

    event_id: Annotated[Optional[str], pydantic.Field(alias="eventId")] = None
    r"""Unique ID for this specific API call or event."""

    session_id: Annotated[Optional[str], pydantic.Field(alias="sessionId")] = None
    r"""ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session."""
