"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TopicAISearchResultTypedDict(TypedDict):
    r"""This schema contains general information about the topic."""

    name: str
    r"""Name of Topic."""
    id: str
    article_count_in_topic: NotRequired[int]
    r"""Number of articles within the topic."""
    article_count_in_topic_tree: NotRequired[int]
    r"""Number of articles in this topic and all sub-topics."""
    created_by: NotRequired[int]
    r"""The ID of the user that created this resource."""
    created_date: NotRequired[datetime]
    department_id: NotRequired[str]
    last_modified_by: NotRequired[int]
    r"""The ID of the user that modified this resource."""
    last_modified_date: NotRequired[datetime]
    child_count: NotRequired[int]


class TopicAISearchResult(BaseModel):
    r"""This schema contains general information about the topic."""

    name: str
    r"""Name of Topic."""

    id: str

    article_count_in_topic: Annotated[
        Optional[int], pydantic.Field(alias="articleCountInTopic")
    ] = None
    r"""Number of articles within the topic."""

    article_count_in_topic_tree: Annotated[
        Optional[int], pydantic.Field(alias="articleCountInTopicTree")
    ] = None
    r"""Number of articles in this topic and all sub-topics."""

    created_by: Annotated[Optional[int], pydantic.Field(alias="createdBy")] = None
    r"""The ID of the user that created this resource."""

    created_date: Annotated[Optional[datetime], pydantic.Field(alias="createdDate")] = (
        None
    )

    department_id: Annotated[Optional[str], pydantic.Field(alias="departmentId")] = None

    last_modified_by: Annotated[
        Optional[int], pydantic.Field(alias="lastModifiedBy")
    ] = None
    r"""The ID of the user that modified this resource."""

    last_modified_date: Annotated[
        Optional[datetime], pydantic.Field(alias="lastModifiedDate")
    ] = None

    child_count: Annotated[Optional[int], pydantic.Field(alias="childCount")] = None
