"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class PortalArticle(BaseSDK):
    def get_article_by_id(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        article_additional_attributes: Optional[
            List[models.ArticleAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        access_source: Optional[models.AccessSource] = "article_view",
        publish_view_id: Optional[str] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Article]:
        r"""Get Article by ID

        ## Overview
        * The Get Article by ID API allows a user to retrieve an Article using its ID.
        * Additional Article attributes and contextual views can be specified in the query parameters.

        * This API returns structured authoring attributes of Issue, Environment, Cause and Confidence Level when the following conditions are met:
        * The \"Allow Structured Authoring\" setting is enabled at the partition/department level through the Administrative Console.
        * The \"Use Structured Authoring\" flag is set on the article type.

        ## Prerequisites
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param article_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | additionalInfo | Additional information provided as Article metadata. | articleType | The Article type and its attributes. | articleKeywords | A comma-separated list of keywords associated with this Article. | articleState | The current state of the Article. States include A (Authoring), S (Staging), and P (Published). | articleSummary | A brief summary of the Article, provided as metadata. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | departmentId | ID of the department for which this Article belongs to. | description | The Article's description. | expirationDate | The date that the Article is set to expire. | attachments | The Article's attachments | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article. | includeInGenAI | Indicates whether this Article is used for eGain's generative AI features. | isSubscribed | Indicates whether the Article is subscribed for notifications.  | languageCode | The language code of the Article language.  | link | The link object, used to retrieve the details of the Article. | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths. | versionId | The ID of the Article version that is returned.
        :param custom_additional_attributes:
        :param access_source: Provides information about the method in which the Article is accessed and is used for self-service analytics. Refer to the eGain User Guide regarding \"Article View Contexts\".  | Name | Description  | ---- | ----------- | article_view | View an Article directly using its ID. | article_view_more_related_Article  | View related articles of an Article using its ID. | article_view_basic_search | View an Article via a basic search. | article_view_adv_search | View an Article via an advanced search. | article_view_guided_help | View an Article via a Guided Help solution. | article_view_browse_topic | View an Article via browsing a topic. | article_view_browse_tree | View an Article via browsing a topic tree. | article_view_popular_articles | View an Article using the Popular Items list in the Self-Service portal. | article_view_useful_items | View Article using the Useful Items list in the Self-Service portal. | article_view_widget | View an Article via a widget. | article_view_announcement | View an Article from the announcement section in the Self-Service portal. | article_view_bookmarked | View a bookmarked Article. | article_view_subscription_notification | View an Article from a subscription notification. | article_view_guided_help_additional_info | View an Article via additional information from a Guided Help search. | view_articles_pending_compliance | View an Article via Read & Sign in the Self-Service portal. | type_ahead_Suggestion | View an Article from a type-ahead Suggestion in the Self-Service portal. | semantic_Suggestion | View an Article from a semantic Suggestion in the Self-Service portal. | instant_answer | View an Article via an Instant Answers solution. | instant_answer_reference | View an Article that is used as a reference for an Instant Answers solution.
        :param publish_view_id: The ID of a publish view for an Article. A publish view is a set of tags used to generate multiple editions of the same Article for display on the self-service portal. Publish views are used in conjunction with single sourcing to tailor the content of an Article to a specific audience by granting access to an Article's version to users that possess the same tags.<br><br>A publish view ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleByIDRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            article_additional_attributes=article_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            access_source=access_source,
            publish_view_id=publish_view_id,
            workflow_milestone=workflow_milestone,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleById",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Article, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_by_id_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        article_additional_attributes: Optional[
            List[models.ArticleAdditionalAttributes]
        ] = None,
        custom_additional_attributes: Optional[str] = None,
        access_source: Optional[models.AccessSource] = "article_view",
        publish_view_id: Optional[str] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Article]:
        r"""Get Article by ID

        ## Overview
        * The Get Article by ID API allows a user to retrieve an Article using its ID.
        * Additional Article attributes and contextual views can be specified in the query parameters.

        * This API returns structured authoring attributes of Issue, Environment, Cause and Confidence Level when the following conditions are met:
        * The \"Allow Structured Authoring\" setting is enabled at the partition/department level through the Administrative Console.
        * The \"Use Structured Authoring\" flag is set on the article type.

        ## Prerequisites
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param article_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | additionalInfo | Additional information provided as Article metadata. | articleType | The Article type and its attributes. | articleKeywords | A comma-separated list of keywords associated with this Article. | articleState | The current state of the Article. States include A (Authoring), S (Staging), and P (Published). | articleSummary | A brief summary of the Article, provided as metadata. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | departmentId | ID of the department for which this Article belongs to. | description | The Article's description. | expirationDate | The date that the Article is set to expire. | attachments | The Article's attachments | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article. | includeInGenAI | Indicates whether this Article is used for eGain's generative AI features. | isSubscribed | Indicates whether the Article is subscribed for notifications.  | languageCode | The language code of the Article language.  | link | The link object, used to retrieve the details of the Article. | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths. | versionId | The ID of the Article version that is returned.
        :param custom_additional_attributes:
        :param access_source: Provides information about the method in which the Article is accessed and is used for self-service analytics. Refer to the eGain User Guide regarding \"Article View Contexts\".  | Name | Description  | ---- | ----------- | article_view | View an Article directly using its ID. | article_view_more_related_Article  | View related articles of an Article using its ID. | article_view_basic_search | View an Article via a basic search. | article_view_adv_search | View an Article via an advanced search. | article_view_guided_help | View an Article via a Guided Help solution. | article_view_browse_topic | View an Article via browsing a topic. | article_view_browse_tree | View an Article via browsing a topic tree. | article_view_popular_articles | View an Article using the Popular Items list in the Self-Service portal. | article_view_useful_items | View Article using the Useful Items list in the Self-Service portal. | article_view_widget | View an Article via a widget. | article_view_announcement | View an Article from the announcement section in the Self-Service portal. | article_view_bookmarked | View a bookmarked Article. | article_view_subscription_notification | View an Article from a subscription notification. | article_view_guided_help_additional_info | View an Article via additional information from a Guided Help search. | view_articles_pending_compliance | View an Article via Read & Sign in the Self-Service portal. | type_ahead_Suggestion | View an Article from a type-ahead Suggestion in the Self-Service portal. | semantic_Suggestion | View an Article from a semantic Suggestion in the Self-Service portal. | instant_answer | View an Article via an Instant Answers solution. | instant_answer_reference | View an Article that is used as a reference for an Instant Answers solution.
        :param publish_view_id: The ID of a publish view for an Article. A publish view is a set of tags used to generate multiple editions of the same Article for display on the self-service portal. Publish views are used in conjunction with single sourcing to tailor the content of an Article to a specific audience by granting access to an Article's version to users that possess the same tags.<br><br>A publish view ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleByIDRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            article_additional_attributes=article_additional_attributes,
            custom_additional_attributes=custom_additional_attributes,
            access_source=access_source,
            publish_view_id=publish_view_id,
            workflow_milestone=workflow_milestone,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleById",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Article, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_article_by_id_with_editions(
        self,
        *,
        accept_language: models.AcceptLanguage,
        article_id: str,
        language: models.MandatoryLanguageQueryParameter,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ArticleWithEditions:
        r"""Get Article By ID with Editions

        ## Overview
        * This API allows a user to retrieve an article with all its editions.
        * If there are no editions for the article, the response will contain the base content of the article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language used for fetching the details of a resource. Resources available in different languages may differ from each other.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleByIDWithEditionsRequest(
            accept_language=accept_language,
            article_id=article_id,
            language=language,
        )

        req = self._build_request(
            method="GET",
            path="/articles/{articleID}/witheditions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleByIdWithEditions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleWithEditions, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_by_id_with_editions_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        article_id: str,
        language: models.MandatoryLanguageQueryParameter,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ArticleWithEditions:
        r"""Get Article By ID with Editions

        ## Overview
        * This API allows a user to retrieve an article with all its editions.
        * If there are no editions for the article, the response will contain the base content of the article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language used for fetching the details of a resource. Resources available in different languages may differ from each other.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleByIDWithEditionsRequest(
            accept_language=accept_language,
            article_id=article_id,
            language=language,
        )

        req = self._build_request_async(
            method="GET",
            path="/articles/{articleID}/witheditions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleByIdWithEditions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleWithEditions, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_article_edition_details(
        self,
        *,
        accept_language: models.AcceptLanguage,
        article_id: str,
        publish_view_id: str,
        language: models.MandatoryLanguageQueryParameter,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EditionWithContent:
        r"""Get Article Edition Details

        ## Overview
        * This API allows a user to retrieve an article with all its editions.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param article_id: The ID of the Article. Both numeric and alternate ID formats are supported.<br><br>Valid numerical IDs are 15-19 digits long.
        :param publish_view_id: Publish View Id of the article on which operation is performed.
        :param language: The language used for fetching the details of a resource. Resources available in different languages may differ from each other.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleEditionDetailsRequest(
            accept_language=accept_language,
            article_id=article_id,
            publish_view_id=publish_view_id,
            language=language,
        )

        req = self._build_request(
            method="GET",
            path="/articles/{articleID}/editions/{publishViewId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleEditionDetails",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EditionWithContent, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_edition_details_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        article_id: str,
        publish_view_id: str,
        language: models.MandatoryLanguageQueryParameter,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.EditionWithContent:
        r"""Get Article Edition Details

        ## Overview
        * This API allows a user to retrieve an article with all its editions.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param article_id: The ID of the Article. Both numeric and alternate ID formats are supported.<br><br>Valid numerical IDs are 15-19 digits long.
        :param publish_view_id: Publish View Id of the article on which operation is performed.
        :param language: The language used for fetching the details of a resource. Resources available in different languages may differ from each other.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleEditionDetailsRequest(
            accept_language=accept_language,
            article_id=article_id,
            publish_view_id=publish_view_id,
            language=language,
        )

        req = self._build_request_async(
            method="GET",
            path="/articles/{articleID}/editions/{publishViewId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleEditionDetails",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.EditionWithContent, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def add_to_reply(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        version_id: str,
        language: Union[
            models.ArticleActivityLinkLanguage,
            models.ArticleActivityLinkLanguageTypedDict,
        ],
        edition_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Add Article to Reply

        ## Overview
        The Add Article to Reply API captures events for articles used in a reply for a digital channel activity.

        Note:  Either the <code>x-ext-activity-id</code> or<br><code>x-ext-integration-id</code> and <code>x-ext-interaction-id</code> header must be provided.

        ## Permissions
        * Only Agents can invoke this API.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param version_id: An Article version's ID.
        :param language: The knowledge base language in which the version is created.
        :param edition_id: An Article edition's ID.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddToReplyRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            article_activity_link=models.ArticleActivityLink(
                version_id=version_id,
                edition_id=edition_id,
                language=utils.get_pydantic_model(
                    language, models.ArticleActivityLinkLanguage
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/addtoreply",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.article_activity_link,
                False,
                False,
                "json",
                models.ArticleActivityLink,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AddToReply",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def add_to_reply_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        version_id: str,
        language: Union[
            models.ArticleActivityLinkLanguage,
            models.ArticleActivityLinkLanguageTypedDict,
        ],
        edition_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Add Article to Reply

        ## Overview
        The Add Article to Reply API captures events for articles used in a reply for a digital channel activity.

        Note:  Either the <code>x-ext-activity-id</code> or<br><code>x-ext-integration-id</code> and <code>x-ext-interaction-id</code> header must be provided.

        ## Permissions
        * Only Agents can invoke this API.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param version_id: An Article version's ID.
        :param language: The knowledge base language in which the version is created.
        :param edition_id: An Article edition's ID.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddToReplyRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            article_activity_link=models.ArticleActivityLink(
                version_id=version_id,
                edition_id=edition_id,
                language=utils.get_pydantic_model(
                    language, models.ArticleActivityLinkLanguage
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/addtoreply",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.article_activity_link,
                False,
                False,
                "json",
                models.ArticleActivityLink,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AddToReply",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def add_as_reference(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        version_id: str,
        language: Union[
            models.ArticleActivityLinkLanguage,
            models.ArticleActivityLinkLanguageTypedDict,
        ],
        edition_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Add as Reference

        ## Overview
        The Add as Reference API captures events for articles that are referenced by agents replying inside of a digital channel activity.

        Note: Either the <code>x-ext-activity-id</code> or<br><code>x-ext-integration-id</code> and <code>x-ext-interaction-id</code> header must be provided.

        ## Permissions
        * Only Agents can invoke this API.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param version_id: An Article version's ID.
        :param language: The knowledge base language in which the version is created.
        :param edition_id: An Article edition's ID.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddAsReferenceRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            article_activity_link=models.ArticleActivityLink(
                version_id=version_id,
                edition_id=edition_id,
                language=utils.get_pydantic_model(
                    language, models.ArticleActivityLinkLanguage
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/addasreference",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.article_activity_link,
                False,
                False,
                "json",
                models.ArticleActivityLink,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AddAsReference",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def add_as_reference_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        version_id: str,
        language: Union[
            models.ArticleActivityLinkLanguage,
            models.ArticleActivityLinkLanguageTypedDict,
        ],
        edition_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Add as Reference

        ## Overview
        The Add as Reference API captures events for articles that are referenced by agents replying inside of a digital channel activity.

        Note: Either the <code>x-ext-activity-id</code> or<br><code>x-ext-integration-id</code> and <code>x-ext-interaction-id</code> header must be provided.

        ## Permissions
        * Only Agents can invoke this API.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param version_id: An Article version's ID.
        :param language: The knowledge base language in which the version is created.
        :param edition_id: An Article edition's ID.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddAsReferenceRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            article_activity_link=models.ArticleActivityLink(
                version_id=version_id,
                edition_id=edition_id,
                language=utils.get_pydantic_model(
                    language, models.ArticleActivityLinkLanguage
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/addasreference",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.article_activity_link,
                False,
                False,
                "json",
                models.ArticleActivityLink,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AddAsReference",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_articles_in_topic(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        dollar_filter_topic_id: str,
        search_profile_id: Optional[str] = None,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        dollar_filter_tags: Optional[str] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        sort: Optional[models.ArticleSort] = None,
        order: Optional[models.ArticleSortOrder] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Articles in Topic

        ## Overview
        The Get Articles in Topic API allows a user to retrieve the browsable articles in a topic.

        ## Prerequisites
        * Set the Article type’s parameter “Include in browse on portals” to \"Yes\" for an article to be returned by this API.
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain published views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.

        ## Permissions
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param dollar_filter_topic_id: The ID of the topic. It is used to restrict to a specific topic.
        :param search_profile_id: Search Profile ID
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param dollar_filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param sort: Articles to be sorted on.
        :param order: Sort order of articles.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticlesInTopicRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            search_profile_id=search_profile_id,
            dollar_filter_topic_id=dollar_filter_topic_id,
            article_result_additional_attributes=article_result_additional_attributes,
            dollar_filter_tags=dollar_filter_tags,
            workflow_milestone=workflow_milestone,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
            sort=sort,
            order=order,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticlesInTopic",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_articles_in_topic_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        dollar_filter_topic_id: str,
        search_profile_id: Optional[str] = None,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        dollar_filter_tags: Optional[str] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        sort: Optional[models.ArticleSort] = None,
        order: Optional[models.ArticleSortOrder] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Articles in Topic

        ## Overview
        The Get Articles in Topic API allows a user to retrieve the browsable articles in a topic.

        ## Prerequisites
        * Set the Article type’s parameter “Include in browse on portals” to \"Yes\" for an article to be returned by this API.
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain published views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.

        ## Permissions
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param dollar_filter_topic_id: The ID of the topic. It is used to restrict to a specific topic.
        :param search_profile_id: Search Profile ID
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param dollar_filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param sort: Articles to be sorted on.
        :param order: Sort order of articles.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticlesInTopicRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            search_profile_id=search_profile_id,
            dollar_filter_topic_id=dollar_filter_topic_id,
            article_result_additional_attributes=article_result_additional_attributes,
            dollar_filter_tags=dollar_filter_tags,
            workflow_milestone=workflow_milestone,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
            sort=sort,
            order=order,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticlesInTopic",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_article_attachment_by_id(
        self,
        *,
        accept_language: models.AcceptLanguage,
        attachment_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AttachmentContentResult:
        r"""Get Article Attachment By ID

        ## Overview
        This API allows one article attachment identified by an attachment ID to be retrieved.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param attachment_id: The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleAttachmentByIDRequest(
            accept_language=accept_language,
            attachment_id=attachment_id,
        )

        req = self._build_request(
            method="GET",
            path="/articles/attachments/{attachmentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleAttachmentById",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AttachmentContentResult, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_attachment_by_id_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        attachment_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AttachmentContentResult:
        r"""Get Article Attachment By ID

        ## Overview
        This API allows one article attachment identified by an attachment ID to be retrieved.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param attachment_id: The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleAttachmentByIDRequest(
            accept_language=accept_language,
            attachment_id=attachment_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/articles/attachments/{attachmentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleAttachmentById",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AttachmentContentResult, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_attachment_by_id_in_portal(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        attachment_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AttachmentContentResult]:
        r"""Get Article Attachment in Portal

        ## Overview
        The Get Article Attachment API retrieves an attachment associated to an article by calling the attachment ID for a specified portal ID.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param attachment_id: The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAttachmentByIDInPortalRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            attachment_id=attachment_id,
            language=language,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/attachments/{attachmentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getAttachmentByIdInPortal",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AttachmentContentResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_attachment_by_id_in_portal_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        attachment_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AttachmentContentResult]:
        r"""Get Article Attachment in Portal

        ## Overview
        The Get Article Attachment API retrieves an attachment associated to an article by calling the attachment ID for a specified portal ID.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param attachment_id: The ID of the attachment.<br><br>An attachment ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAttachmentByIDInPortalRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            attachment_id=attachment_id,
            language=language,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/attachments/{attachmentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getAttachmentByIdInPortal",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AttachmentContentResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_related_articles(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        dollar_filter_tags: Optional[str] = None,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Related Articles

        ## Overview
        The Get Related Articles API retrieves all related articles associated to a given article.

        ## Prerequisites
        * Set the Article type’s parameter “Include in browse on portals” to \"Yes\" for an article to be returned by this API.
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.

        ## Permissions
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param dollar_filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRelatedArticlesRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            dollar_filter_tags=dollar_filter_tags,
            article_result_additional_attributes=article_result_additional_attributes,
            workflow_milestone=workflow_milestone,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/related",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRelatedArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_related_articles_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        dollar_filter_tags: Optional[str] = None,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Related Articles

        ## Overview
        The Get Related Articles API retrieves all related articles associated to a given article.

        ## Prerequisites
        * Set the Article type’s parameter “Include in browse on portals” to \"Yes\" for an article to be returned by this API.
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.

        ## Permissions
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param dollar_filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRelatedArticlesRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            dollar_filter_tags=dollar_filter_tags,
            article_result_additional_attributes=article_result_additional_attributes,
            workflow_milestone=workflow_milestone,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/related",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getRelatedArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_announcement_articles(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        dollar_filter_tags: Optional[str] = None,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Announcement Articles

        ## Overview
        The Get Announcement Articles API returns a portal's announcement articles. Only displayable announcement articles in the portal are returned.

        ## Prerequisites
        * For an article to display or be returned, set the Article type’s parameter, “Include in browse on portals,” to \"Yes\".
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.

        ## Permissions
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.



        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param dollar_filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAnnouncementArticlesRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            dollar_filter_tags=dollar_filter_tags,
            article_result_additional_attributes=article_result_additional_attributes,
            workflow_milestone=workflow_milestone,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/announcements",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getAnnouncementArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_announcement_articles_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        dollar_filter_tags: Optional[str] = None,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Announcement Articles

        ## Overview
        The Get Announcement Articles API returns a portal's announcement articles. Only displayable announcement articles in the portal are returned.

        ## Prerequisites
        * For an article to display or be returned, set the Article type’s parameter, “Include in browse on portals,” to \"Yes\".
        * Agents without a user profile and customers in a portal without a default user profile only have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Agents with a user profile and customers in a portal with a default user profile have access to articles that:
        * Do not contain any access tags.
        * Do not contain any publish views.
        * Contain publish views without any associated tags.
        * Contain access tags that are also in the assigned user profiles.
        * Contain publish views with associated tags that are also in the assigned user profiles.

        ## Permissions
        * Agents with the following assigned actions can view updates to articles currently being processed in workflows:
        * View Author Portal – Allows agents to view updates to articles at any stage in a workflow.
        * View Staging Portal – Allows agents to view updates to articles in the Staging stage or a subsequent stage in a workflow.



        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param dollar_filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAnnouncementArticlesRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            dollar_filter_tags=dollar_filter_tags,
            article_result_additional_attributes=article_result_additional_attributes,
            workflow_milestone=workflow_milestone,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/announcements",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getAnnouncementArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_article_ratings(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleRatingsResponse]:
        r"""Get Article Ratings

        ## Overview
        The Get Article Ratings API returns ratings set for an Article. These ratings help you to assess the quality, helpfulness, or relevance of an article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleRatingsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/ratings",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleRatings",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleRatingsResponse, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_ratings_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleRatingsResponse]:
        r"""Get Article Ratings

        ## Overview
        The Get Article Ratings API returns ratings set for an Article. These ratings help you to assess the quality, helpfulness, or relevance of an article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticleRatingsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/ratings",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticleRatings",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleRatingsResponse, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def rate_article(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        score: int,
        language: Optional[models.LanguageQueryParameter] = None,
        comments: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Rate an Article

        ## Overview
        The Rate an Article API allows a user to set a rating for an article. These ratings allow you to assess the quality, helpfulness, or relevance of an article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param score: A positive number. Each portal can have its own scoring guidelines.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param comments: A comment about the Article rating.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RateArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            score=score,
            comments=comments,
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/ratings",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="rateArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def rate_article_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        score: int,
        language: Optional[models.LanguageQueryParameter] = None,
        comments: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Rate an Article

        ## Overview
        The Rate an Article API allows a user to set a rating for an article. These ratings allow you to assess the quality, helpfulness, or relevance of an article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param score: A positive number. Each portal can have its own scoring guidelines.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param comments: A comment about the Article rating.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RateArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            score=score,
            comments=comments,
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/ratings",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="rateArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_pending_compliance_articles(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        compliance_article_result_additional_attributes: Optional[
            List[models.ComplianceArticleResultAdditionalAttributes]
        ] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ComplianceArticleResults]:
        r"""Get Pending Article Compliances

        ## Overview
        The Get Pending Article Compliances API retrieves all compliance-enabled articles in a portal that need to be read by the current user. Results are sorted in ascending order of the compliance due date.

        ## Prerequisites
        * The Article compliances that are returned must be:
        * Available for the current user profile.
        * Displayable. An article is displayable when the \"Include in browse on portals\" property is enabled for the article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param compliance_article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | updateSummary | Summary of the Article update. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetPendingComplianceArticlesRequest(
            accept_language=accept_language,
            compliance_article_result_additional_attributes=compliance_article_result_additional_attributes,
            portal_id=portal_id,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/compliance/pending",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getPendingComplianceArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ComplianceArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_pending_compliance_articles_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        compliance_article_result_additional_attributes: Optional[
            List[models.ComplianceArticleResultAdditionalAttributes]
        ] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ComplianceArticleResults]:
        r"""Get Pending Article Compliances

        ## Overview
        The Get Pending Article Compliances API retrieves all compliance-enabled articles in a portal that need to be read by the current user. Results are sorted in ascending order of the compliance due date.

        ## Prerequisites
        * The Article compliances that are returned must be:
        * Available for the current user profile.
        * Displayable. An article is displayable when the \"Include in browse on portals\" property is enabled for the article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param compliance_article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | updateSummary | Summary of the Article update. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetPendingComplianceArticlesRequest(
            accept_language=accept_language,
            compliance_article_result_additional_attributes=compliance_article_result_additional_attributes,
            portal_id=portal_id,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/compliance/pending",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getPendingComplianceArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ComplianceArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_acknowledged_compliance_articles(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        compliance_article_result_additional_attributes: Optional[
            List[models.ComplianceArticleResultAdditionalAttributes]
        ] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ComplianceArticleResults]:
        r"""Get Acknowledged Article Compliances

        ## Overview
        The Get Acknowledged Article Compliances API retrieves all compliance-enabled articles in a portal that have been read by the current user in the last 60 days. Results are sorted in descending order of the acknowledgement date.

        ## Prerequisites
        * The Article compliances that are returned must be:
        * Available for the current user profile.
        * Displayable. An article is displayable when the \"Include in browse on portals\" property is enabled for the article.
        * Acknowledged within the last 60 days.
        * Only the latest version of a republished compliance article will be shown.
        * Results will be sorted in descending order of acknowledgment date.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param compliance_article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | updateSummary | Summary of the Article update. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAcknowledgedComplianceArticlesRequest(
            accept_language=accept_language,
            compliance_article_result_additional_attributes=compliance_article_result_additional_attributes,
            portal_id=portal_id,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/compliance/acknowledged",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getAcknowledgedComplianceArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ComplianceArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_acknowledged_compliance_articles_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        compliance_article_result_additional_attributes: Optional[
            List[models.ComplianceArticleResultAdditionalAttributes]
        ] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ComplianceArticleResults]:
        r"""Get Acknowledged Article Compliances

        ## Overview
        The Get Acknowledged Article Compliances API retrieves all compliance-enabled articles in a portal that have been read by the current user in the last 60 days. Results are sorted in descending order of the acknowledgement date.

        ## Prerequisites
        * The Article compliances that are returned must be:
        * Available for the current user profile.
        * Displayable. An article is displayable when the \"Include in browse on portals\" property is enabled for the article.
        * Acknowledged within the last 60 days.
        * Only the latest version of a republished compliance article will be shown.
        * Results will be sorted in descending order of acknowledgment date.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param compliance_article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | updateSummary | Summary of the Article update. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAcknowledgedComplianceArticlesRequest(
            accept_language=accept_language,
            compliance_article_result_additional_attributes=compliance_article_result_additional_attributes,
            portal_id=portal_id,
            language=language,
            pagenum=pagenum,
            pagesize=pagesize,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/compliance/acknowledged",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getAcknowledgedComplianceArticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ComplianceArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def comply_article(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Comply With an Article

        ## Overview
        The Comply with an Article API allows the user to comply with an article by passing the Article's ID, which marks it as read by the user.

        ## Prerequisites
        * The user must be an agent and:
        * Be available in the portal.
        * Be available for the current user profile.
        * Have the Article's compliance policy enabled.
        * If the Article has Access Tags, then it must be available for the agent's current user profile.
        * If the Article has Publish Views, then at least one edition of the Article must be available for the agent's current user profile.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ComplyArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/comply",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="complyArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def comply_article_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Comply With an Article

        ## Overview
        The Comply with an Article API allows the user to comply with an article by passing the Article's ID, which marks it as read by the user.

        ## Prerequisites
        * The user must be an agent and:
        * Be available in the portal.
        * Be available for the current user profile.
        * Have the Article's compliance policy enabled.
        * If the Article has Access Tags, then it must be available for the agent's current user profile.
        * If the Article has Publish Views, then at least one edition of the Article must be available for the agent's current user profile.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ComplyArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/comply",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="complyArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_my_subscription(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""My Subscription

        ## Overview
        The My Subscription API allows authenticated users and agents to retrieve the list of articles to which they are subscribed.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMySubscriptionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            workflow_milestone=workflow_milestone,
            pagenum=pagenum,
            pagesize=pagesize,
            article_result_additional_attributes=article_result_additional_attributes,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/subscribed",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getMySubscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_my_subscription_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        workflow_milestone: Optional[models.WorkflowMilestone] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""My Subscription

        ## Overview
        The My Subscription API allows authenticated users and agents to retrieve the list of articles to which they are subscribed.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param workflow_milestone: For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMySubscriptionRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            workflow_milestone=workflow_milestone,
            pagenum=pagenum,
            pagesize=pagesize,
            article_result_additional_attributes=article_result_additional_attributes,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/subscribed",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getMySubscription",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def subscribe_article(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Subscribe to an Article

        ## Overview
        The Subscribe to an Article API allows eGain users, authenticated customers and agents to subscribe and receive notifications about changes to an Article.

        ## Prerequisites
        * Notifications are sent only if the following conditions are met:
        * The Article content has been modified since the last published version.
        * The attachment list has been modified since the last published version.
        * The author has checked the \"Include Article in new and modified Article list\" option while publishing the Article.
        * For the Subscribe to an Article API to execute successfully:
        * The Article must be in the portal.
        * The user must have provided an email address.

        ## Permissions
        * Agent Permissions: The following permissions are required if the user is an agent:
        * If the Article has Access Tags:
        * The Article must be available for the agent's current user profile.
        * If the Article has Publish Views:
        * At least one edition of the Article must be available for the agent's current user profile.
        * If the Article has filters and the \"tags query parameter\" is provided:
        * The Article filters must match the provided tags or tag groups.
        * Customer Permissions: The following permissions are required if the user is a customer:
        * If the Article has Access Tags:
        * The portal must have a default user profile
        * The Article must be available for the portal's default user profile.
        * If the Article has Publish Views:
        * The portal must have a default user profile
        * At least one edition must be available for the portal's default user profile.
        * If the Article has filters and the \"tags query parameter\" is provided, then the Article filters must match the provided tags or tag groups.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SubscribeArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/subscribe",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="subscribeArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def subscribe_article_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Subscribe to an Article

        ## Overview
        The Subscribe to an Article API allows eGain users, authenticated customers and agents to subscribe and receive notifications about changes to an Article.

        ## Prerequisites
        * Notifications are sent only if the following conditions are met:
        * The Article content has been modified since the last published version.
        * The attachment list has been modified since the last published version.
        * The author has checked the \"Include Article in new and modified Article list\" option while publishing the Article.
        * For the Subscribe to an Article API to execute successfully:
        * The Article must be in the portal.
        * The user must have provided an email address.

        ## Permissions
        * Agent Permissions: The following permissions are required if the user is an agent:
        * If the Article has Access Tags:
        * The Article must be available for the agent's current user profile.
        * If the Article has Publish Views:
        * At least one edition of the Article must be available for the agent's current user profile.
        * If the Article has filters and the \"tags query parameter\" is provided:
        * The Article filters must match the provided tags or tag groups.
        * Customer Permissions: The following permissions are required if the user is a customer:
        * If the Article has Access Tags:
        * The portal must have a default user profile
        * The Article must be available for the portal's default user profile.
        * If the Article has Publish Views:
        * The portal must have a default user profile
        * At least one edition must be available for the portal's default user profile.
        * If the Article has filters and the \"tags query parameter\" is provided, then the Article filters must match the provided tags or tag groups.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SubscribeArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/subscribe",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="subscribeArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def unsubscribe_article(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        unsubscription_token: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Unsubscribe to an Article

        ## Overview
        The Unsubscribe to an Article API allows authenticated users and agents to unsubscribe to an Article for which they were earlier subscribed to receive change notifications.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param unsubscription_token: An encrypted token that contains information about \"object/userId/userType/userProfileId\". This is used to unsubscribe the user from Article change notifications sent via email, without necessitating that the user be logged into the eGain application.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UnsubscribeArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            unsubscription_token=unsubscription_token,
        )

        req = self._build_request(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/unsubscribe",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="unsubscribeArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def unsubscribe_article_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        unsubscription_token: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Unsubscribe to an Article

        ## Overview
        The Unsubscribe to an Article API allows authenticated users and agents to unsubscribe to an Article for which they were earlier subscribed to receive change notifications.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param unsubscription_token: An encrypted token that contains information about \"object/userId/userType/userProfileId\". This is used to unsubscribe the user from Article change notifications sent via email, without necessitating that the user be logged into the eGain application.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UnsubscribeArticleRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            unsubscription_token=unsubscription_token,
        )

        req = self._build_request_async(
            method="PUT",
            path="/portals/{portalID}/articles/{articleID}/unsubscribe",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="unsubscribeArticle",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_article_permissions_by_id(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticlePermissionsResult]:
        r"""Get Article Permissions By ID

        ## Overview
        * The Get Article Permission by ID permits a user to retrieve permissions associated to an article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticlePermissionsByIDRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/permissions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticlePermissionsById",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticlePermissionsResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_permissions_by_id_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticlePermissionsResult]:
        r"""Get Article Permissions By ID

        ## Overview
        * The Get Article Permission by ID permits a user to retrieve permissions associated to an article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticlePermissionsByIDRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/permissions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticlePermissionsById",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticlePermissionsResult, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_article_personalization(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        workflow_milestone: Optional[
            models.GetArticlePersonalizationWorkflowMilestone
        ] = "publish",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Personalization]:
        r"""Get Article Personalization Details

        ## Overview
        The Get Article Personalization Details API allows agents to retrieve the personalization tag details of an Article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param workflow_milestone: Workflow milestone of the Article
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticlePersonalizationRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            workflow_milestone=workflow_milestone,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/personalization",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticlePersonalization",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Personalization, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_article_personalization_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        article_id: str,
        language: Optional[models.LanguageQueryParameter] = None,
        workflow_milestone: Optional[
            models.GetArticlePersonalizationWorkflowMilestone
        ] = "publish",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.Personalization]:
        r"""Get Article Personalization Details

        ## Overview
        The Get Article Personalization Details API allows agents to retrieve the personalization tag details of an Article.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param article_id: The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param workflow_milestone: Workflow milestone of the Article
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetArticlePersonalizationRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            article_id=article_id,
            language=language,
            workflow_milestone=workflow_milestone,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/articles/{articleID}/personalization",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getArticlePersonalization",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Personalization, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
