"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .additionalsnippets import AdditionalSnippets, AdditionalSnippetsTypedDict
from .aitopicbreadcrumb import AITopicBreadcrumb, AITopicBreadcrumbTypedDict
from .schemas_tags import SchemasTags, SchemasTagsTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Any, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ArticleAISearchResultDocType = Literal[
    "HTML",
    "DOCX",
    "PDF",
    "PPTX",
]
r"""Format of the source document (HTML, DOCX, PPTX or PDF)."""


ArticleAISearchResultSource = Literal[
    "eGain Article",
    "eGain Attachment",
]
r"""The source type."""


ArticleAISearchResultType = Literal[
    "STRING",
    "INTEGER",
    "BOOLEAN",
    "DATETIME",
]
r"""The custom attribute's type."""


class ArticleAISearchResultCustomAttributeTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The custom attribute's name."""
    value: NotRequired[List[str]]
    r"""The custom attribute's values."""
    type: NotRequired[ArticleAISearchResultType]
    r"""The custom attribute's type."""


class ArticleAISearchResultCustomAttribute(BaseModel):
    name: Optional[str] = None
    r"""The custom attribute's name."""

    value: Optional[List[str]] = None
    r"""The custom attribute's values."""

    type: Optional[ArticleAISearchResultType] = None
    r"""The custom attribute's type."""


class ArticleTypeAttributesTypedDict(TypedDict):
    r"""The type of the Article and its attributes."""

    type_name: NotRequired[str]
    r"""Indicates the article category name."""
    article_type_id: NotRequired[Any]
    r"""The ID of the Article Type."""


class ArticleTypeAttributes(BaseModel):
    r"""The type of the Article and its attributes."""

    type_name: Annotated[Optional[str], pydantic.Field(alias="typeName")] = None
    r"""Indicates the article category name."""

    article_type_id: Annotated[Optional[Any], pydantic.Field(alias="articleTypeId")] = (
        None
    )
    r"""The ID of the Article Type."""


class ArticleAISearchResultTypedDict(TypedDict):
    r"""Represents a single document or snippet returned by search, along with its metadata and relevance score."""

    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    name: str
    r"""The name of the Article or source content."""
    doc_type: ArticleAISearchResultDocType
    r"""Format of the source document (HTML, DOCX, PPTX or PDF)."""
    source: ArticleAISearchResultSource
    r"""The source type."""
    snippet: str
    r"""A semantic snippet of the article content."""
    topic_breadcrumb: List[AITopicBreadcrumbTypedDict]
    r"""A list of topics from the root topic to this Article. There may be multiple paths."""
    relevance_score: float
    r"""Generated confidence score (0.0-1.0) for the snippet's relevance to the query."""
    doc_name: NotRequired[str]
    r"""Name of the attachment, if an attachment was used as the source content."""
    custom_attributes: NotRequired[List[ArticleAISearchResultCustomAttributeTypedDict]]
    r"""Custom attributes assigned to an article"""
    keyword_snippet: NotRequired[str]
    r"""A keyword search snippet of article content."""
    additional_snippets: NotRequired[List[AdditionalSnippetsTypedDict]]
    r"""An array of snippets belonging to the same article."""
    additional_snippet_count: NotRequired[int]
    r"""Number of additional snippets."""
    contextual_summary: NotRequired[str]
    r"""Contextual Summary generated as part of metadata for embedding."""
    modified_date: NotRequired[str]
    r"""The date on which the Article was last modified."""
    header_path: NotRequired[str]
    r"""The header path of the snippet retrieved."""
    tag_categories: NotRequired[List[SchemasTagsTypedDict]]
    r"""An array of tag categories. Note that the total number of tag categories cannot exceed 20."""
    article_type_attributes: NotRequired[ArticleTypeAttributesTypedDict]
    r"""The type of the Article and its attributes."""


class ArticleAISearchResult(BaseModel):
    r"""Represents a single document or snippet returned by search, along with its metadata and relevance score."""

    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    name: str
    r"""The name of the Article or source content."""

    doc_type: Annotated[ArticleAISearchResultDocType, pydantic.Field(alias="docType")]
    r"""Format of the source document (HTML, DOCX, PPTX or PDF)."""

    source: ArticleAISearchResultSource
    r"""The source type."""

    snippet: str
    r"""A semantic snippet of the article content."""

    topic_breadcrumb: Annotated[
        List[AITopicBreadcrumb], pydantic.Field(alias="topicBreadcrumb")
    ]
    r"""A list of topics from the root topic to this Article. There may be multiple paths."""

    relevance_score: Annotated[float, pydantic.Field(alias="relevanceScore")]
    r"""Generated confidence score (0.0-1.0) for the snippet's relevance to the query."""

    doc_name: Annotated[Optional[str], pydantic.Field(alias="docName")] = None
    r"""Name of the attachment, if an attachment was used as the source content."""

    custom_attributes: Annotated[
        Optional[List[ArticleAISearchResultCustomAttribute]],
        pydantic.Field(alias="customAttributes"),
    ] = None
    r"""Custom attributes assigned to an article"""

    keyword_snippet: Annotated[
        Optional[str], pydantic.Field(alias="keywordSnippet")
    ] = None
    r"""A keyword search snippet of article content."""

    additional_snippets: Annotated[
        Optional[List[AdditionalSnippets]], pydantic.Field(alias="additionalSnippets")
    ] = None
    r"""An array of snippets belonging to the same article."""

    additional_snippet_count: Annotated[
        Optional[int], pydantic.Field(alias="additionalSnippetCount")
    ] = None
    r"""Number of additional snippets."""

    contextual_summary: Annotated[
        Optional[str], pydantic.Field(alias="contextualSummary")
    ] = None
    r"""Contextual Summary generated as part of metadata for embedding."""

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the Article was last modified."""

    header_path: Annotated[Optional[str], pydantic.Field(alias="headerPath")] = None
    r"""The header path of the snippet retrieved."""

    tag_categories: Annotated[
        Optional[List[SchemasTags]], pydantic.Field(alias="tagCategories")
    ] = None
    r"""An array of tag categories. Note that the total number of tag categories cannot exceed 20."""

    article_type_attributes: Annotated[
        Optional[ArticleTypeAttributes], pydantic.Field(alias="articleTypeAttributes")
    ] = None
    r"""The type of the Article and its attributes."""
