"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ValidateImportContentType = Literal[
    "AWS S3 bucket",
    "Shared file path",
]
r"""Type of data source"""


class ValidateImportContentCredentialsTypedDict(TypedDict):
    access_key: NotRequired[str]
    secret_key: NotRequired[str]


class ValidateImportContentCredentials(BaseModel):
    access_key: Annotated[Optional[str], pydantic.Field(alias="accessKey")] = None

    secret_key: Annotated[Optional[str], pydantic.Field(alias="secretKey")] = None


class ValidateImportContentDataSourceTypedDict(TypedDict):
    type: ValidateImportContentType
    r"""Type of data source"""
    path: str
    r"""Path of the data source"""
    region: NotRequired[str]
    r"""Region of the data source"""
    credentials: NotRequired[ValidateImportContentCredentialsTypedDict]


class ValidateImportContentDataSource(BaseModel):
    type: ValidateImportContentType
    r"""Type of data source"""

    path: str
    r"""Path of the data source"""

    region: Optional[str] = None
    r"""Region of the data source"""

    credentials: Optional[ValidateImportContentCredentials] = None


class ValidateImportContentTypedDict(TypedDict):
    data_source: ValidateImportContentDataSourceTypedDict


class ValidateImportContent(BaseModel):
    data_source: Annotated[
        ValidateImportContentDataSource, pydantic.Field(alias="dataSource")
    ]
