"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AdditionalSnippetsDocType = Literal[
    "HTML",
    "DOCX",
    "PDF",
    "PPTX",
]
r"""Format of the source document (HTML, DOCX, PPTX or PDF)."""


class AdditionalSnippetsTypedDict(TypedDict):
    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    name: str
    r"""The name of the Article or source content."""
    doc_type: AdditionalSnippetsDocType
    r"""Format of the source document (HTML, DOCX, PPTX or PDF)."""
    snippet: str
    r"""A snippet of the article content."""
    relevance_score: float
    r"""Generated confidence score (0.0-1.0) for the snippet's relevance to the query."""
    doc_name: NotRequired[str]
    r"""Name of the attachment, if an attachment was used as the source content."""
    keyword_snippet: NotRequired[str]
    r"""A keyword snippet of the article content."""


class AdditionalSnippets(BaseModel):
    id: str
    r"""The ID of the Article. <br><br> An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    name: str
    r"""The name of the Article or source content."""

    doc_type: Annotated[AdditionalSnippetsDocType, pydantic.Field(alias="docType")]
    r"""Format of the source document (HTML, DOCX, PPTX or PDF)."""

    snippet: str
    r"""A snippet of the article content."""

    relevance_score: Annotated[float, pydantic.Field(alias="relevanceScore")]
    r"""Generated confidence score (0.0-1.0) for the snippet's relevance to the query."""

    doc_name: Annotated[Optional[str], pydantic.Field(alias="docName")] = None
    r"""Name of the attachment, if an attachment was used as the source content."""

    keyword_snippet: Annotated[
        Optional[str], pydantic.Field(alias="keywordSnippet")
    ] = None
    r"""A keyword snippet of the article content."""
