"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentforcreatesuggestion import (
    AttachmentForCreateSuggestion,
    AttachmentForCreateSuggestionTypedDict,
)
from .customattribute import CustomAttribute, CustomAttributeTypedDict
from .link import Link, LinkTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ModifySuggestionAttachmentsTypedDict(TypedDict):
    r"""Details of Attachments for the Suggestion."""

    attachment: NotRequired[List[AttachmentForCreateSuggestionTypedDict]]
    r"""The list of Attachments.<br><br>Required if <code>content</code> and <code>Attachments.unlink</code> are both _not_ provided."""
    unlink: NotRequired[List[LinkTypedDict]]
    r"""If provided with references to Attachments, <code>unlink</code> removes the Attachment from the Suggestion.<br><br>If the Attachment has no associated objects, it will be deleted.<br><br>Required if <code>content</code> and <code>Attachments.Attachment</code> are both _not_ provided."""


class ModifySuggestionAttachments(BaseModel):
    r"""Details of Attachments for the Suggestion."""

    attachment: Optional[List[AttachmentForCreateSuggestion]] = None
    r"""The list of Attachments.<br><br>Required if <code>content</code> and <code>Attachments.unlink</code> are both _not_ provided."""

    unlink: Optional[List[Link]] = None
    r"""If provided with references to Attachments, <code>unlink</code> removes the Attachment from the Suggestion.<br><br>If the Attachment has no associated objects, it will be deleted.<br><br>Required if <code>content</code> and <code>Attachments.Attachment</code> are both _not_ provided."""


class ModifySuggestionTypedDict(TypedDict):
    r"""This schema contains information about modifying a Suggestion."""

    id: str
    r"""The ID of the Suggestion. A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    modified_date: str
    r"""The date on which the Suggestion was last modified."""
    name: NotRequired[str]
    r"""The name of the Suggestion."""
    description: NotRequired[str]
    r"""The description of the Suggestion."""
    content: NotRequired[str]
    r"""The content of the Suggestion."""
    attachments: NotRequired[ModifySuggestionAttachmentsTypedDict]
    r"""Details of Attachments for the Suggestion."""
    custom_attributes: NotRequired[List[CustomAttributeTypedDict]]
    r"""Custom Attributes of the Suggestion."""


class ModifySuggestion(BaseModel):
    r"""This schema contains information about modifying a Suggestion."""

    id: str
    r"""The ID of the Suggestion. A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    modified_date: Annotated[str, pydantic.Field(alias="modifiedDate")]
    r"""The date on which the Suggestion was last modified."""

    name: Optional[str] = None
    r"""The name of the Suggestion."""

    description: Optional[str] = None
    r"""The description of the Suggestion."""

    content: Optional[str] = None
    r"""The content of the Suggestion."""

    attachments: Optional[ModifySuggestionAttachments] = None
    r"""Details of Attachments for the Suggestion."""

    custom_attributes: Annotated[
        Optional[List[CustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""Custom Attributes of the Suggestion."""
