"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createdby import CreatedBy, CreatedByTypedDict
from .kblanguages import KbLanguages, KbLanguagesTypedDict
from .link import Link, LinkTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from .portalsettings import PortalSettings, PortalSettingsTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PortalTypedDict(TypedDict):
    id: str
    r"""The alphanumeric ID of the portal.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    name: str
    r"""The name of the portal."""
    department_id: NotRequired[str]
    r"""The ID of the department."""
    description: NotRequired[str]
    r"""The description of the portal."""
    default_content_language_id: NotRequired[str]
    r"""The default ID of the language for the portal content."""
    default_content_language_code: NotRequired[str]
    r"""The IETF code of the default language for the portal content."""
    created_by: NotRequired[CreatedByTypedDict]
    created_date: NotRequired[str]
    r"""The date that the portal was created."""
    modified_by: NotRequired[ModifiedByTypedDict]
    modified_date: NotRequired[str]
    r"""The date on which the portal was last modified."""
    is_structured_authoring_enabled: NotRequired[bool]
    r"""Indicates if Structured Authoring is enabled for the portal."""
    enable_draft_search_in_portal: NotRequired[bool]
    r"""Indicates if Enable Portal Search for Draft and Staging Articles is enabled for the portal."""
    portal_settings: NotRequired[PortalSettingsTypedDict]
    r"""The settings for this portal."""
    kb_languages: NotRequired[KbLanguagesTypedDict]
    r"""KB languages"""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class Portal(BaseModel):
    id: str
    r"""The alphanumeric ID of the portal.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    name: str
    r"""The name of the portal."""

    department_id: Annotated[Optional[str], pydantic.Field(alias="departmentId")] = None
    r"""The ID of the department."""

    description: Optional[str] = None
    r"""The description of the portal."""

    default_content_language_id: Annotated[
        Optional[str], pydantic.Field(alias="defaultContentLanguageId")
    ] = None
    r"""The default ID of the language for the portal content."""

    default_content_language_code: Annotated[
        Optional[str], pydantic.Field(alias="defaultContentLanguageCode")
    ] = None
    r"""The IETF code of the default language for the portal content."""

    created_by: Annotated[Optional[CreatedBy], pydantic.Field(alias="createdBy")] = None

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None
    r"""The date that the portal was created."""

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the portal was last modified."""

    is_structured_authoring_enabled: Annotated[
        Optional[bool], pydantic.Field(alias="isStructuredAuthoringEnabled")
    ] = None
    r"""Indicates if Structured Authoring is enabled for the portal."""

    enable_draft_search_in_portal: Annotated[
        Optional[bool], pydantic.Field(alias="enableDraftSearchInPortal")
    ] = None
    r"""Indicates if Enable Portal Search for Draft and Staging Articles is enabled for the portal."""

    portal_settings: Annotated[
        Optional[PortalSettings], pydantic.Field(alias="portalSettings")
    ] = None
    r"""The settings for this portal."""

    kb_languages: Annotated[
        Optional[KbLanguages], pydantic.Field(alias="kbLanguages")
    ] = None
    r"""KB languages"""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
