"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .referenceresponse import ReferenceResponse, ReferenceResponseTypedDict
from .searchresult import SearchResult, SearchResultTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


RetrieveResponseAnswerType = Literal["certified",]
r"""Specifies that the answer produced was a certified answer."""


class RetrieveResponseAnswerTypedDict(TypedDict):
    r"""If a certified answer is given. The answer object will be present. <br><br> This will be shown only if certified answers are configured and the certified answer meets the configured threshold."""

    answer_value: str
    r"""The certified answer."""
    references: List[ReferenceResponseTypedDict]
    r"""Source used to produce the certified answer."""
    answer_type: RetrieveResponseAnswerType
    r"""Specifies that the answer produced was a certified answer."""
    relevance_score: float
    r"""Confidence score (0.0-1.0) reflecting how well the answer matches the query."""


class RetrieveResponseAnswer(BaseModel):
    r"""If a certified answer is given. The answer object will be present. <br><br> This will be shown only if certified answers are configured and the certified answer meets the configured threshold."""

    answer_value: Annotated[str, pydantic.Field(alias="answerValue")]
    r"""The certified answer."""

    references: List[ReferenceResponse]
    r"""Source used to produce the certified answer."""

    answer_type: Annotated[
        RetrieveResponseAnswerType, pydantic.Field(alias="answerType")
    ]
    r"""Specifies that the answer produced was a certified answer."""

    relevance_score: Annotated[float, pydantic.Field(alias="relevanceScore")]
    r"""Confidence score (0.0-1.0) reflecting how well the answer matches the query."""


RetrieveResponseType = Literal[
    "portal",
    "custom",
]
r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""


class RetrieveResponseChannelTypedDict(TypedDict):
    type: RetrieveResponseType
    r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""
    name: NotRequired[str]
    r"""The channel name."""


class RetrieveResponseChannel(BaseModel):
    type: RetrieveResponseType
    r"""The channel where the query originated, e.g., directly from the portal or via a custom integration."""

    name: Optional[str] = None
    r"""The channel name."""


class RetrieveResponseTypedDict(TypedDict):
    search_results: List[SearchResultTypedDict]
    r"""Top search results with relevance scores and metadata."""
    session_id: str
    r"""ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session."""
    answer: NotRequired[RetrieveResponseAnswerTypedDict]
    r"""If a certified answer is given. The answer object will be present. <br><br> This will be shown only if certified answers are configured and the certified answer meets the configured threshold."""
    channel: NotRequired[RetrieveResponseChannelTypedDict]
    event_id: NotRequired[str]
    r"""Unique ID for this specific API call or event."""


class RetrieveResponse(BaseModel):
    search_results: Annotated[List[SearchResult], pydantic.Field(alias="searchResults")]
    r"""Top search results with relevance scores and metadata."""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session."""

    answer: Optional[RetrieveResponseAnswer] = None
    r"""If a certified answer is given. The answer object will be present. <br><br> This will be shown only if certified answers are configured and the certified answer meets the configured threshold."""

    channel: Optional[RetrieveResponseChannel] = None

    event_id: Annotated[Optional[str], pydantic.Field(alias="eventId")] = None
    r"""Unique ID for this specific API call or event."""
