"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional


class Connectorssearchevents(BaseSDK):
    def create_search_result_event_for_connectors(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        language_code: models.KbLanguageCode,
        q: str,
        number_of_search_results: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Event for Search Using Connectors

        ## Overview
        The Event for Search Using Connectors API creates an event to initiate a search operation for retrieving content from external sources or integrations within the portal.
        It allows users to set up search events based on specified criteria.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language_code: A short language code. A list of codes can be found below:  |Code|Description |----|-----------  |en-US|English (United States) |en-GB|English (United Kingdom) |fr-FR|French (France) |es-ES|Spanish (Spain) |it-IT|Italian (Italy) |de-DE|German (Germany) |nl-NL|Dutch (Netherlands) |pt-BR|Portuguese (Brazil) |pt-PT|Portuguese (Portugal) |da-DK|Danish (Denmark) |sv-SE|Swedish (Sweden) |ru-RU|Russian (Russia) |fr-CA|French (Canada) |zh-CN|Chinese (Simplified, China) |ja-JP|Japanese (Japan) |ko-KR|Korean (South Korea) |nn-NO|Norwegian Nynorsk (Norway)
        :param q: The string to use for the search.
        :param number_of_search_results:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateSearchResultEventForConnectorsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            create_search_result_event_for_connectors=models.CreateSearchResultEventForConnectors(
                language_code=language_code,
                q=q,
                number_of_search_results=number_of_search_results,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/portals/{portalID}/search/connectors/event",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_search_result_event_for_connectors,
                False,
                False,
                "json",
                models.CreateSearchResultEventForConnectors,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createSearchResultEventForConnectors",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def create_search_result_event_for_connectors_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        language_code: models.KbLanguageCode,
        q: str,
        number_of_search_results: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Event for Search Using Connectors

        ## Overview
        The Event for Search Using Connectors API creates an event to initiate a search operation for retrieving content from external sources or integrations within the portal.
        It allows users to set up search events based on specified criteria.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language_code: A short language code. A list of codes can be found below:  |Code|Description |----|-----------  |en-US|English (United States) |en-GB|English (United Kingdom) |fr-FR|French (France) |es-ES|Spanish (Spain) |it-IT|Italian (Italy) |de-DE|German (Germany) |nl-NL|Dutch (Netherlands) |pt-BR|Portuguese (Brazil) |pt-PT|Portuguese (Portugal) |da-DK|Danish (Denmark) |sv-SE|Swedish (Sweden) |ru-RU|Russian (Russia) |fr-CA|French (Canada) |zh-CN|Chinese (Simplified, China) |ja-JP|Japanese (Japan) |ko-KR|Korean (South Korea) |nn-NO|Norwegian Nynorsk (Norway)
        :param q: The string to use for the search.
        :param number_of_search_results:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateSearchResultEventForConnectorsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            create_search_result_event_for_connectors=models.CreateSearchResultEventForConnectors(
                language_code=language_code,
                q=q,
                number_of_search_results=number_of_search_results,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/portals/{portalID}/search/connectors/event",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_search_result_event_for_connectors,
                False,
                False,
                "json",
                models.CreateSearchResultEventForConnectors,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createSearchResultEventForConnectors",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def create_viewed_search_results_event_for_connectors(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        language_code: models.KbLanguageCode,
        q: str,
        url: str,
        title: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Event for Viewed Search Results Using Connectors

        ## Overview
        The Event for Viewed Search Results Using Connectors API creates an event to log when search results from external content are viewed.
        This helps in tracking and analyzing user interactions with search results retrieved from various external sources.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language_code: A short language code. A list of codes can be found below:  |Code|Description |----|-----------  |en-US|English (United States) |en-GB|English (United Kingdom) |fr-FR|French (France) |es-ES|Spanish (Spain) |it-IT|Italian (Italy) |de-DE|German (Germany) |nl-NL|Dutch (Netherlands) |pt-BR|Portuguese (Brazil) |pt-PT|Portuguese (Portugal) |da-DK|Danish (Denmark) |sv-SE|Swedish (Sweden) |ru-RU|Russian (Russia) |fr-CA|French (Canada) |zh-CN|Chinese (Simplified, China) |ja-JP|Japanese (Japan) |ko-KR|Korean (South Korea) |nn-NO|Norwegian Nynorsk (Norway)
        :param q: The string to use for the search.
        :param url: The URL of the search result.
        :param title: The title of the search result.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateViewedSearchResultsEventForConnectorsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            create_viewed_search_result_event_for_connectors=models.CreateViewedSearchResultEventForConnectors(
                language_code=language_code,
                q=q,
                url=url,
                title=title,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/portals/{portalID}/view/searchresults/connectors/event",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_viewed_search_result_event_for_connectors,
                False,
                False,
                "json",
                models.CreateViewedSearchResultEventForConnectors,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createViewedSearchResultsEventForConnectors",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def create_viewed_search_results_event_for_connectors_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        language_code: models.KbLanguageCode,
        q: str,
        url: str,
        title: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Event for Viewed Search Results Using Connectors

        ## Overview
        The Event for Viewed Search Results Using Connectors API creates an event to log when search results from external content are viewed.
        This helps in tracking and analyzing user interactions with search results retrieved from various external sources.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language_code: A short language code. A list of codes can be found below:  |Code|Description |----|-----------  |en-US|English (United States) |en-GB|English (United Kingdom) |fr-FR|French (France) |es-ES|Spanish (Spain) |it-IT|Italian (Italy) |de-DE|German (Germany) |nl-NL|Dutch (Netherlands) |pt-BR|Portuguese (Brazil) |pt-PT|Portuguese (Portugal) |da-DK|Danish (Denmark) |sv-SE|Swedish (Sweden) |ru-RU|Russian (Russia) |fr-CA|French (Canada) |zh-CN|Chinese (Simplified, China) |ja-JP|Japanese (Japan) |ko-KR|Korean (South Korea) |nn-NO|Norwegian Nynorsk (Norway)
        :param q: The string to use for the search.
        :param url: The URL of the search result.
        :param title: The title of the search result.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateViewedSearchResultsEventForConnectorsRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            create_viewed_search_result_event_for_connectors=models.CreateViewedSearchResultEventForConnectors(
                language_code=language_code,
                q=q,
                url=url,
                title=title,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/portals/{portalID}/view/searchresults/connectors/event",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_viewed_search_result_event_for_connectors,
                False,
                False,
                "json",
                models.CreateViewedSearchResultEventForConnectors,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createViewedSearchResultsEventForConnectors",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "406",
                "415",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, ["415", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
