"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .articletype import ArticleType, ArticleTypeTypedDict
from .metadata import Metadata, MetadataTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ActionSearchType = Literal[
    "control",
    "article",
]
r"""type of the action"""


class ActionSearchTypedDict(TypedDict):
    accept_count: NotRequired[int]
    r"""number of times action was accepted"""
    has_additional_info: NotRequired[bool]
    r"""indicates if action has additional information"""
    metadata: NotRequired[List[MetadataTypedDict]]
    r"""Metadata in action search."""
    article_id: NotRequired[str]
    r"""The ID of the Article .<br>The ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    case_id: NotRequired[str]
    r"""The numerical ID of the case."""
    passed_threshold_value: NotRequired[bool]
    r"""indicates if the case has passed the threshold value"""
    reject_count: NotRequired[int]
    r"""The number of times action was rejected"""
    short_name: NotRequired[str]
    r"""short name"""
    score: NotRequired[int]
    r"""score of the case"""
    name: NotRequired[str]
    r"""name of the case"""
    action_id: NotRequired[str]
    r"""The ID of the Action."""
    type: NotRequired[ActionSearchType]
    r"""type of the action"""
    article_type: NotRequired[ArticleTypeTypedDict]
    r"""The type of the Article and its attributes."""


class ActionSearch(BaseModel):
    accept_count: Annotated[Optional[int], pydantic.Field(alias="acceptCount")] = None
    r"""number of times action was accepted"""

    has_additional_info: Annotated[
        Optional[bool], pydantic.Field(alias="hasAdditionalInfo")
    ] = None
    r"""indicates if action has additional information"""

    metadata: Optional[List[Metadata]] = None
    r"""Metadata in action search."""

    article_id: Annotated[Optional[str], pydantic.Field(alias="articleId")] = None
    r"""The ID of the Article .<br>The ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    case_id: Annotated[Optional[str], pydantic.Field(alias="caseId")] = None
    r"""The numerical ID of the case."""

    passed_threshold_value: Annotated[
        Optional[bool], pydantic.Field(alias="passedThresholdValue")
    ] = None
    r"""indicates if the case has passed the threshold value"""

    reject_count: Annotated[Optional[int], pydantic.Field(alias="rejectCount")] = None
    r"""The number of times action was rejected"""

    short_name: Annotated[Optional[str], pydantic.Field(alias="shortName")] = None
    r"""short name"""

    score: Optional[int] = None
    r"""score of the case"""

    name: Optional[str] = None
    r"""name of the case"""

    action_id: Annotated[Optional[str], pydantic.Field(alias="actionId")] = None
    r"""The ID of the Action."""

    type: Optional[ActionSearchType] = None
    r"""type of the action"""

    article_type: Annotated[
        Optional[ArticleType], pydantic.Field(alias="articleType")
    ] = None
    r"""The type of the Article and its attributes."""
