"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ArticleActivityLinkCode = Literal[
    "en-US",
    "en-GB",
    "fr-FR",
    "es-ES",
    "it-IT",
    "de-DE",
    "nl-NL",
    "pt-BR",
    "pt-PT",
    "da-DK",
    "sv-SE",
    "ru-RU",
    "fr-CA",
    "zh-CN",
    "ja-JP",
    "ko-KR",
]
r"""The code of the language."""


class ArticleActivityLinkLanguageTypedDict(TypedDict):
    r"""The knowledge base language in which the version is created."""

    code: ArticleActivityLinkCode
    r"""The code of the language."""


class ArticleActivityLinkLanguage(BaseModel):
    r"""The knowledge base language in which the version is created."""

    code: ArticleActivityLinkCode
    r"""The code of the language."""


class ArticleActivityLinkTypedDict(TypedDict):
    version_id: str
    r"""An Article version's ID."""
    language: ArticleActivityLinkLanguageTypedDict
    r"""The knowledge base language in which the version is created."""
    edition_id: NotRequired[str]
    r"""An Article edition's ID."""


class ArticleActivityLink(BaseModel):
    version_id: Annotated[str, pydantic.Field(alias="versionId")]
    r"""An Article version's ID."""

    language: ArticleActivityLinkLanguage
    r"""The knowledge base language in which the version is created."""

    edition_id: Annotated[Optional[str], pydantic.Field(alias="editionId")] = None
    r"""An Article edition's ID."""
