"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .link import Link, LinkTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ArticleListResultTypedDict(TypedDict):
    name: str
    r"""The name of the article list."""
    id: str
    r"""The ID of the article list.<br><br>An article list ID is either a 4-digit number or composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    description: NotRequired[str]
    r"""The description of the article list. The maximum allowed article list description size is 1 KB."""
    type_id: NotRequired[str]
    r"""The type of the article list."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class ArticleListResult(BaseModel):
    name: str
    r"""The name of the article list."""

    id: str
    r"""The ID of the article list.<br><br>An article list ID is either a 4-digit number or composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    description: Optional[str] = None
    r"""The description of the article list. The maximum allowed article list description size is 1 KB."""

    type_id: Annotated[Optional[str], pydantic.Field(alias="typeId")] = None
    r"""The type of the article list."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
