"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .link import Link, LinkTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AttachmentSummaryTypedDict(TypedDict):
    r"""Summary attributes for an Attachment."""

    id: NotRequired[str]
    r"""The ID of the Attachment."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""
    file_name: NotRequired[str]
    r"""The name of the Attachment file.<li>This must not exceed 255 characters.</li>"""
    size: NotRequired[int]
    r"""The size of the Attachment.<li>Limited to 25MB.</li>"""


class AttachmentSummary(BaseModel):
    r"""Summary attributes for an Attachment."""

    id: Optional[str] = None
    r"""The ID of the Attachment."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""

    file_name: Annotated[Optional[str], pydantic.Field(alias="fileName")] = None
    r"""The name of the Attachment file.<li>This must not exceed 255 characters.</li>"""

    size: Optional[int] = None
    r"""The size of the Attachment.<li>Limited to 25MB.</li>"""
