"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .casebasesearchsettings import (
    CasebaseSearchSettings,
    CasebaseSearchSettingsTypedDict,
)
from .kblanguages import KbLanguages, KbLanguagesTypedDict
from .link import Link, LinkTypedDict
from .profileresult import ProfileResult, ProfileResultTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


CasebaseStatus = Literal[
    "author",
    "live",
    "qa",
]
r"""status of the Casebase"""


class CasebaseTypedDict(TypedDict):
    casebase_id: NotRequired[str]
    r"""The numerical ID of the Casebase."""
    name: NotRequired[str]
    r"""name of the Casebase Release."""
    id: NotRequired[str]
    r"""The numerical ID of the Casebase Release."""
    status: NotRequired[CasebaseStatus]
    r"""status of the Casebase"""
    profiles: NotRequired[List[ProfileResultTypedDict]]
    r"""All Guided Help Profiles associated with Casebase release"""
    search_settings: NotRequired[CasebaseSearchSettingsTypedDict]
    languages: NotRequired[KbLanguagesTypedDict]
    r"""KB languages"""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class Casebase(BaseModel):
    casebase_id: Annotated[Optional[str], pydantic.Field(alias="casebaseId")] = None
    r"""The numerical ID of the Casebase."""

    name: Optional[str] = None
    r"""name of the Casebase Release."""

    id: Optional[str] = None
    r"""The numerical ID of the Casebase Release."""

    status: Optional[CasebaseStatus] = None
    r"""status of the Casebase"""

    profiles: Optional[List[ProfileResult]] = None
    r"""All Guided Help Profiles associated with Casebase release"""

    search_settings: Annotated[
        Optional[CasebaseSearchSettings], pydantic.Field(alias="searchSettings")
    ] = None

    languages: Optional[KbLanguages] = None
    r"""KB languages"""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
