"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


UserType = Literal[
    "customer",
    "agent",
]
r"""The type of the user associated with the bookmark."""


class CreateBookmarkTypedDict(TypedDict):
    resource_id: NotRequired[str]
    r"""The ID of the article or topic associated with this bookmark. A case ID or an article ID is composed of a 2-4 letter prefix, followed by a dash and 15 digits.<br><br>This attribute must be provided if <code>resourceType</code> is set to \"1 - Article\" or \"2 - Topic\"."""
    user_id: NotRequired[str]
    r"""The ID of the user associated with the bookmark."""
    user_type: NotRequired[UserType]
    r"""The type of the user associated with the bookmark."""
    bookmark_name: NotRequired[str]
    r"""The name of the bookmark."""
    resource_type: NotRequired[int]
    r"""Determines the type of resource:
    <li>1 - Article</li>
    <li>2 - Topic</li>
    <li>3 - External Content</li>
    """
    resource_name: NotRequired[str]
    r"""The name of the resource associated with the bookmark.<br><br>This attribute is only available for article and topic bookmarks."""
    external_content_id: NotRequired[str]
    r"""The ID of the external content.<br><br>This attribute must be provided if <code>resourceType</code> is set to \"3 - External Content\"."""


class CreateBookmark(BaseModel):
    resource_id: Annotated[Optional[str], pydantic.Field(alias="resourceId")] = None
    r"""The ID of the article or topic associated with this bookmark. A case ID or an article ID is composed of a 2-4 letter prefix, followed by a dash and 15 digits.<br><br>This attribute must be provided if <code>resourceType</code> is set to \"1 - Article\" or \"2 - Topic\"."""

    user_id: Annotated[Optional[str], pydantic.Field(alias="userId")] = None
    r"""The ID of the user associated with the bookmark."""

    user_type: Annotated[Optional[UserType], pydantic.Field(alias="userType")] = None
    r"""The type of the user associated with the bookmark."""

    bookmark_name: Annotated[Optional[str], pydantic.Field(alias="bookmarkName")] = None
    r"""The name of the bookmark."""

    resource_type: Annotated[Optional[int], pydantic.Field(alias="resourceType")] = None
    r"""Determines the type of resource:
    <li>1 - Article</li>
    <li>2 - Topic</li>
    <li>3 - External Content</li>
    """

    resource_name: Annotated[Optional[str], pydantic.Field(alias="resourceName")] = None
    r"""The name of the resource associated with the bookmark.<br><br>This attribute is only available for article and topic bookmarks."""

    external_content_id: Annotated[
        Optional[str], pydantic.Field(alias="externalContentId")
    ] = None
    r"""The ID of the external content.<br><br>This attribute must be provided if <code>resourceType</code> is set to \"3 - External Content\"."""
