"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentforcreatesuggestion import (
    AttachmentForCreateSuggestion,
    AttachmentForCreateSuggestionTypedDict,
)
from .customattribute import CustomAttribute, CustomAttributeTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RelatedArticleForCreateUpdateDeleteSuggestionTypedDict(TypedDict):
    r"""The Article that the Suggestion was created for."""

    id: NotRequired[str]
    r"""The ID of a Related Article.<br><br>An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""


class RelatedArticleForCreateUpdateDeleteSuggestion(BaseModel):
    r"""The Article that the Suggestion was created for."""

    id: Optional[str] = None
    r"""The ID of a Related Article.<br><br>An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""


class CreateSuggestionAttachmentsTypedDict(TypedDict):
    r"""Details of Attachments for the Suggestion."""

    attachment: NotRequired[List[AttachmentForCreateSuggestionTypedDict]]
    r"""The list of Attachments."""


class CreateSuggestionAttachments(BaseModel):
    r"""Details of Attachments for the Suggestion."""

    attachment: Optional[List[AttachmentForCreateSuggestion]] = None
    r"""The list of Attachments."""


CreateSuggestionCode = Literal[
    "en-US",
    "en-GB",
    "fr-FR",
    "es-ES",
    "it-IT",
    "de-DE",
    "nl-NL",
    "pt-BR",
    "pt-PT",
    "da-DK",
    "sv-SE",
    "ru-RU",
    "fr-CA",
    "zh-CN",
    "ja-JP",
    "ko-KR",
]
r"""The code of the language."""


class CreateSuggestionLanguageTypedDict(TypedDict):
    r"""The knowledge base language in which the Suggestion is created."""

    code: CreateSuggestionCode
    r"""The code of the language."""


class CreateSuggestionLanguage(BaseModel):
    r"""The knowledge base language in which the Suggestion is created."""

    code: CreateSuggestionCode
    r"""The code of the language."""


class CreateSuggestionTypedDict(TypedDict):
    r"""This schema contains information about a Suggestion."""

    name: str
    r"""The name of the Suggestion."""
    content: str
    r"""The content of the Suggestion."""
    language: CreateSuggestionLanguageTypedDict
    r"""The knowledge base language in which the Suggestion is created."""
    description: NotRequired[str]
    r"""The description of the Suggestion."""
    feedback_article: NotRequired[
        RelatedArticleForCreateUpdateDeleteSuggestionTypedDict
    ]
    r"""The Article that the Suggestion was created for."""
    attachments: NotRequired[CreateSuggestionAttachmentsTypedDict]
    r"""Details of Attachments for the Suggestion."""
    custom_attributes: NotRequired[List[CustomAttributeTypedDict]]
    r"""The Custom Attributes of the Suggestion."""


class CreateSuggestion(BaseModel):
    r"""This schema contains information about a Suggestion."""

    name: str
    r"""The name of the Suggestion."""

    content: str
    r"""The content of the Suggestion."""

    language: CreateSuggestionLanguage
    r"""The knowledge base language in which the Suggestion is created."""

    description: Optional[str] = None
    r"""The description of the Suggestion."""

    feedback_article: Annotated[
        Optional[RelatedArticleForCreateUpdateDeleteSuggestion],
        pydantic.Field(alias="feedbackArticle"),
    ] = None
    r"""The Article that the Suggestion was created for."""

    attachments: Optional[CreateSuggestionAttachments] = None
    r"""Details of Attachments for the Suggestion."""

    custom_attributes: Annotated[
        Optional[List[CustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""The Custom Attributes of the Suggestion."""
