"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .mandatorylanguagequeryparameter import MandatoryLanguageQueryParameter
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing_extensions import Annotated, TypedDict


class GetArticleEditionDetailsRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    article_id: str
    r"""The ID of the Article. Both numeric and alternate ID formats are supported.<br><br>Valid numerical IDs are 15-19 digits long."""
    publish_view_id: str
    r"""Publish View Id of the article on which operation is performed."""
    language: MandatoryLanguageQueryParameter
    r"""The language used for fetching the details of a resource. Resources available in different languages may differ from each other."""


class GetArticleEditionDetailsRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    article_id: Annotated[
        str,
        pydantic.Field(alias="articleID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the Article. Both numeric and alternate ID formats are supported.<br><br>Valid numerical IDs are 15-19 digits long."""

    publish_view_id: Annotated[
        str,
        pydantic.Field(alias="publishViewId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Publish View Id of the article on which operation is performed."""

    language: Annotated[
        MandatoryLanguageQueryParameter,
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The language used for fetching the details of a resource. Resources available in different languages may differ from each other."""
