"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .articleresultadditionalattributes import ArticleResultAdditionalAttributes
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetRelatedArticlesForSuggestionRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    suggestion_id: str
    r"""The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    article_result_additional_attributes: NotRequired[
        List[ArticleResultAdditionalAttributes]
    ]
    r"""The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.

    #### Default Attributes
    These Article attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the Article.
    | name  | The name of the Article.
    | articleType | The Article Type and its attributes.
    | createdBy | The ID, first name, middle name and last name of the user that created the Article.
    | createdDate | The date that the Article was created.
    | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments.
    | languageCode | The language code of the Article language.
    | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article.
    | modifiedDate | The date that the Article was last modified on.
    | link | The link object, used to retrieve the details of the Article.
    | versionId | The ID of the Article version that is returned.

    """


class GetRelatedArticlesForSuggestionRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    suggestion_id: Annotated[
        str,
        pydantic.Field(alias="suggestionID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    article_result_additional_attributes: Annotated[
        Optional[List[ArticleResultAdditionalAttributes]],
        pydantic.Field(alias="articleResultAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.

    #### Default Attributes
    These Article attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the Article.
    | name  | The name of the Article.
    | articleType | The Article Type and its attributes.
    | createdBy | The ID, first name, middle name and last name of the user that created the Article.
    | createdDate | The date that the Article was created.
    | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments.
    | languageCode | The language code of the Article language.
    | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article.
    | modifiedDate | The date that the Article was last modified on.
    | link | The link object, used to retrieve the details of the Article.
    | versionId | The ID of the Article version that is returned.

    """
