"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .image import Image, ImageTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SchemasAnswerTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the answer"""
    depth: NotRequired[int]
    r"""depth of the answer"""
    is_invisible: NotRequired[bool]
    r"""Flag indicating if answer is visible"""
    text: NotRequired[str]
    r"""Text of the answer"""
    image: NotRequired[ImageTypedDict]
    concept_name: NotRequired[str]
    r"""name of the answer"""
    concept_id: NotRequired[str]
    r"""Id of the answer"""
    lower_value: NotRequired[int]
    r"""lower value of the answer"""
    upper_value: NotRequired[int]
    r"""upper value of the answer"""
    enum_lower_value: NotRequired[str]
    r"""lower value of enum answer"""
    enum_upper_value: NotRequired[str]
    r"""upper value of enum answer"""
    lower_inclusive: NotRequired[bool]
    r"""Value indicating if lower value is inclusive"""
    upper_inclusive: NotRequired[bool]
    r"""Value indicating if upper value is inclusive"""
    partial_min: NotRequired[int]
    r"""Partial minimum"""
    partial_max: NotRequired[int]
    r"""Partial maximim"""


class SchemasAnswer(BaseModel):
    id: Optional[str] = None
    r"""ID of the answer"""

    depth: Optional[int] = None
    r"""depth of the answer"""

    is_invisible: Annotated[Optional[bool], pydantic.Field(alias="isInvisible")] = None
    r"""Flag indicating if answer is visible"""

    text: Optional[str] = None
    r"""Text of the answer"""

    image: Optional[Image] = None

    concept_name: Annotated[Optional[str], pydantic.Field(alias="conceptName")] = None
    r"""name of the answer"""

    concept_id: Annotated[Optional[str], pydantic.Field(alias="conceptId")] = None
    r"""Id of the answer"""

    lower_value: Annotated[Optional[int], pydantic.Field(alias="lowerValue")] = None
    r"""lower value of the answer"""

    upper_value: Annotated[Optional[int], pydantic.Field(alias="upperValue")] = None
    r"""upper value of the answer"""

    enum_lower_value: Annotated[
        Optional[str], pydantic.Field(alias="enumLowerValue")
    ] = None
    r"""lower value of enum answer"""

    enum_upper_value: Annotated[
        Optional[str], pydantic.Field(alias="enumUpperValue")
    ] = None
    r"""upper value of enum answer"""

    lower_inclusive: Annotated[
        Optional[bool], pydantic.Field(alias="lowerInclusive")
    ] = None
    r"""Value indicating if lower value is inclusive"""

    upper_inclusive: Annotated[
        Optional[bool], pydantic.Field(alias="upperInclusive")
    ] = None
    r"""Value indicating if upper value is inclusive"""

    partial_min: Annotated[Optional[int], pydantic.Field(alias="partialMin")] = None
    r"""Partial minimum"""

    partial_max: Annotated[Optional[int], pydantic.Field(alias="partialMax")] = None
    r"""Partial maximim"""
