"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schemas_tag import SchemasTag, SchemasTagTypedDict
from .schemas_taggroup import SchemasTagGroup, SchemasTagGroupTypedDict
from .userview import UserView, UserViewTypedDict
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreatedDateAndTimeTypedDict(TypedDict):
    r"""Date the Tag Category was created."""

    date_: datetime
    r"""The date in the format <code>YYYY-MM-DDTHH:MM:SS</code>."""
    user: NotRequired[UserViewTypedDict]


class CreatedDateAndTime(BaseModel):
    r"""Date the Tag Category was created."""

    date_: Annotated[datetime, pydantic.Field(alias="date")]
    r"""The date in the format <code>YYYY-MM-DDTHH:MM:SS</code>."""

    user: Optional[UserView] = None


class LastModifiedDateAndTimeTypedDict(TypedDict):
    r"""Date of last modification."""

    date_: datetime
    r"""The date in the format <code>YYYY-MM-DDTHH:MM:SS</code>."""
    user: NotRequired[UserViewTypedDict]


class LastModifiedDateAndTime(BaseModel):
    r"""Date of last modification."""

    date_: Annotated[datetime, pydantic.Field(alias="date")]
    r"""The date in the format <code>YYYY-MM-DDTHH:MM:SS</code>."""

    user: Optional[UserView] = None


class SchemasTagCategoryTypedDict(TypedDict):
    name: NotRequired[str]
    r"""name of the tag category."""
    tag_group: NotRequired[List[SchemasTagGroupTypedDict]]
    tag: NotRequired[List[SchemasTagTypedDict]]
    created: NotRequired[CreatedDateAndTimeTypedDict]
    r"""Date the Tag Category was created."""
    last_modified: NotRequired[LastModifiedDateAndTimeTypedDict]
    r"""Date of last modification."""


class SchemasTagCategory(BaseModel):
    name: Optional[str] = None
    r"""name of the tag category."""

    tag_group: Annotated[
        Optional[List[SchemasTagGroup]], pydantic.Field(alias="tagGroup")
    ] = None

    tag: Optional[List[SchemasTag]] = None

    created: Optional[CreatedDateAndTime] = None
    r"""Date the Tag Category was created."""

    last_modified: Annotated[
        Optional[LastModifiedDateAndTime], pydantic.Field(alias="lastModified")
    ] = None
    r"""Date of last modification."""
