"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .stringattributevalue import StringAttributeValue, StringAttributeValueTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ValueType = Literal[
    "String",
    "Integer",
    "Decimal",
    "Date",
    "Boolean",
]
r"""The data type of the value of the attribute."""


class SearchFilterAttributeTypedDict(TypedDict):
    r"""This includes the custom attributes that have been added to the portal for filtering."""

    internal_name: NotRequired[str]
    r"""The internal name of a custom attribute."""
    external_name: NotRequired[str]
    r"""The external or public name of a custom attribute."""
    value_type: NotRequired[ValueType]
    r"""The data type of the value of the attribute."""
    is_enumerated: NotRequired[bool]
    r"""Whether the valueType is enumerated."""
    is_multiselect: NotRequired[bool]
    r"""Whether the user can select multiple values."""
    value: NotRequired[StringAttributeValueTypedDict]
    r"""An attribute can have an external value such as a readable label, and an internal value such as a unique ID. This schema provides both the internal and external values for one attribute."""


class SearchFilterAttribute(BaseModel):
    r"""This includes the custom attributes that have been added to the portal for filtering."""

    internal_name: Annotated[Optional[str], pydantic.Field(alias="internalName")] = None
    r"""The internal name of a custom attribute."""

    external_name: Annotated[Optional[str], pydantic.Field(alias="externalName")] = None
    r"""The external or public name of a custom attribute."""

    value_type: Annotated[Optional[ValueType], pydantic.Field(alias="valueType")] = None
    r"""The data type of the value of the attribute."""

    is_enumerated: Annotated[Optional[bool], pydantic.Field(alias="isEnumerated")] = (
        None
    )
    r"""Whether the valueType is enumerated."""

    is_multiselect: Annotated[Optional[bool], pydantic.Field(alias="isMultiselect")] = (
        None
    )
    r"""Whether the user can select multiple values."""

    value: Optional[StringAttributeValue] = None
    r"""An attribute can have an external value such as a readable label, and an internal value such as a unique ID. This schema provides both the internal and external values for one attribute."""
