"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .optionalarticleattributes import OptionalArticleAttributes
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SearchPriorToEscalationRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    escalation_id: str
    r"""The ID (uuid) of the customer escalation.

    """
    filter_articles_in_topic_tree: NotRequired[str]
    r"""This parameter will restrict the search scope to the provided topic and it's sub topic."""
    additional_attributes: NotRequired[OptionalArticleAttributes]
    r"""The fields of the article to be returned."""
    max_results: NotRequired[int]
    r"""The \"maxResults\" parameter specifies the number of articles that should be included in the response.

    It is only required when the escalation type is chat escalation.If not specified then default value 5 will be considered for chat escalation.

    If the escalation type is email, the maximum results value specified in the portal settings for email escalation will be taken into consideration.

    """
    pagenum: NotRequired[int]
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""
    pagesize: NotRequired[int]
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25"""


class SearchPriorToEscalationRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    escalation_id: Annotated[
        str,
        pydantic.Field(alias="escalationId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID (uuid) of the customer escalation.

    """

    filter_articles_in_topic_tree: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[articles-in-topic-tree]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This parameter will restrict the search scope to the provided topic and it's sub topic."""

    additional_attributes: Annotated[
        Optional[OptionalArticleAttributes],
        pydantic.Field(alias="additionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The fields of the article to be returned."""

    max_results: Annotated[
        Optional[int],
        pydantic.Field(alias="maxResults"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The \"maxResults\" parameter specifies the number of articles that should be included in the response.

    It is only required when the escalation type is chat escalation.If not specified then default value 5 will be considered for chat escalation.

    If the escalation type is email, the maximum results value specified in the portal settings for email escalation will be taken into consideration.

    """

    pagenum: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagenum"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""

    pagesize: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagesize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 25
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.<br>Valid range of 5-75<br>_Default value_: 25"""
