"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UnsubscribeArticleRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    article_id: str
    r"""The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits."""
    unsubscription_token: NotRequired[str]
    r"""An encrypted token that contains information about \"object/userId/userType/userProfileId\". This is used to unsubscribe the user from Article change notifications sent via email, without necessitating that the user be logged into the eGain application."""


class UnsubscribeArticleRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    article_id: Annotated[
        str,
        pydantic.Field(alias="articleID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits."""

    unsubscription_token: Annotated[
        Optional[str],
        pydantic.Field(alias="unsubscriptionToken"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An encrypted token that contains information about \"object/userId/userType/userProfileId\". This is used to unsubscribe the user from Article change notifications sent via email, without necessitating that the user be logged into the eGain application."""
