"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class Export(BaseSDK):
    def export_content(
        self,
        *,
        portal_id: str,
        language: Union[
            models.KnowledgeExportLanguage, models.KnowledgeExportLanguageTypedDict
        ],
        resource_types: List[models.KnowledgeExportResourceType],
        data_destination: Union[
            models.DataDestination, models.DataDestinationTypedDict
        ],
        article_categories: Optional[models.ArticleCategories] = "searchable",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ExportContentResponse:
        r"""Export Knowledge

        ## Overview
        The Content Export API initiates a bulk export of the Knowledge Hub to a client-provided Amazon S3 bucket or SFTP server path.
        It returns a URL with a Job ID to enable tracking the status of this asynchronous operation.
        Each export job can send multiple JSON files, depending on the total number of items to process.
        More than one bulk export can take place, as needed, one per portal.

        ## Permission
        * Only a client application can invoke this API.


        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language: The Knowledge Base language in which the content is created.
        :param resource_types: Types of Knowledge Hub resources to export. Multiple values can be specified using a comma-separated list. Details of a single portal are exported.  Articles whose state is Published are returned. | Portal Attribute Name | Description  | ------------------------------- | ----------- | id | The ID of the Portal in Readable format. | alternateId | The system-generated ID of the Portal in long format. | name  | The name of the Portal. | description | The Portal's description. | departmentId | ID of the department this Portal belongs to.  | defaultContentLanguageId | The default ID of the language for the portal content.  | Topic Attribute Name | Description  | ------------------------------ | ----------- | id | The ID of the Topic in Readable form. | alternateId | The system-generated ID of the Topic in long form. | name  | The name of the Topic. | departmentId | ID of the department this Topic belongs to. | modifiedDate | The date when the Topic was last modified on. | topicHomeArticleId | The ID of the Article used as the home page of this Topic. | childCount | Total number of children sub-topis below the current Topic. | subTopicIds | Array with the list of sub-topics (all levels of the topic hierarchy). | parentTopicId | ID of the parent Topic. -1 if it is the root Topic. | imageURL | URL of the inline Topic image. | customAttributes | One or more comma-separated names for Topic custom attributes defined by the user to be returned.  | Article Attribute Name | Description  | ---------------------- | ----------- | id | The ID of the Article in Readable form. | alternateId | The system-generated ID of the Article in long form. | name  | The name of the Article. | additionalInfo | Additional information provided as Article metadata.  | type | The Article type object and its attributes. | keywords | A comma-separated list of keywords associated with this Article, provided as metadata. | summary | A brief summary of the Article, provided as metadata. | state | The state of the Article. State P (Published). | departmentId | ID of the department this Article belongs to.  | description | The description of the Article. | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article. | attachements | The Article's uploaded attachments and their IDs. | includeInGenAI  | Indicates whether this Article is used for eGain's generative AI features. | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths. | versionId | The ID of the Article version that is returned. | expirationDate | The date that the Article is set to expire.   | averageRating | Average rating of the Article. | timesRated | Number or times the Article was rated.   | availabilityDate | The date the Article is set to be available.    | articleMacro | The macro of the Article.              | content | path to the Article content in .html format. | customAttributes | One or more comma-separated names for Article custom attributes defined by the user to be returned. | personalization | Article personalization details, incuding tag categories. | editions | The editions of the Article, including the publish profile (view) associated with each edition.
        :param data_destination:
        :param article_categories: Category of articles to return. All includes browsable and searchable.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.KnowledgeExport(
            article_categories=article_categories,
            portal_id=portal_id,
            language=utils.get_pydantic_model(language, models.KnowledgeExportLanguage),
            resource_types=resource_types,
            data_destination=utils.get_pydantic_model(
                data_destination, models.DataDestination
            ),
        )

        req = self._build_request(
            method="POST",
            path="/content/export",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.KnowledgeExport
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="exportContent",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "202", "*"):
            return models.ExportContentResponse(
                headers=utils.get_response_headers(http_res.headers)
            )
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def export_content_async(
        self,
        *,
        portal_id: str,
        language: Union[
            models.KnowledgeExportLanguage, models.KnowledgeExportLanguageTypedDict
        ],
        resource_types: List[models.KnowledgeExportResourceType],
        data_destination: Union[
            models.DataDestination, models.DataDestinationTypedDict
        ],
        article_categories: Optional[models.ArticleCategories] = "searchable",
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ExportContentResponse:
        r"""Export Knowledge

        ## Overview
        The Content Export API initiates a bulk export of the Knowledge Hub to a client-provided Amazon S3 bucket or SFTP server path.
        It returns a URL with a Job ID to enable tracking the status of this asynchronous operation.
        Each export job can send multiple JSON files, depending on the total number of items to process.
        More than one bulk export can take place, as needed, one per portal.

        ## Permission
        * Only a client application can invoke this API.


        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param language: The Knowledge Base language in which the content is created.
        :param resource_types: Types of Knowledge Hub resources to export. Multiple values can be specified using a comma-separated list. Details of a single portal are exported.  Articles whose state is Published are returned. | Portal Attribute Name | Description  | ------------------------------- | ----------- | id | The ID of the Portal in Readable format. | alternateId | The system-generated ID of the Portal in long format. | name  | The name of the Portal. | description | The Portal's description. | departmentId | ID of the department this Portal belongs to.  | defaultContentLanguageId | The default ID of the language for the portal content.  | Topic Attribute Name | Description  | ------------------------------ | ----------- | id | The ID of the Topic in Readable form. | alternateId | The system-generated ID of the Topic in long form. | name  | The name of the Topic. | departmentId | ID of the department this Topic belongs to. | modifiedDate | The date when the Topic was last modified on. | topicHomeArticleId | The ID of the Article used as the home page of this Topic. | childCount | Total number of children sub-topis below the current Topic. | subTopicIds | Array with the list of sub-topics (all levels of the topic hierarchy). | parentTopicId | ID of the parent Topic. -1 if it is the root Topic. | imageURL | URL of the inline Topic image. | customAttributes | One or more comma-separated names for Topic custom attributes defined by the user to be returned.  | Article Attribute Name | Description  | ---------------------- | ----------- | id | The ID of the Article in Readable form. | alternateId | The system-generated ID of the Article in long form. | name  | The name of the Article. | additionalInfo | Additional information provided as Article metadata.  | type | The Article type object and its attributes. | keywords | A comma-separated list of keywords associated with this Article, provided as metadata. | summary | A brief summary of the Article, provided as metadata. | state | The state of the Article. State P (Published). | departmentId | ID of the department this Article belongs to.  | description | The description of the Article. | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article. | attachements | The Article's uploaded attachments and their IDs. | includeInGenAI  | Indicates whether this Article is used for eGain's generative AI features. | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths. | versionId | The ID of the Article version that is returned. | expirationDate | The date that the Article is set to expire.   | averageRating | Average rating of the Article. | timesRated | Number or times the Article was rated.   | availabilityDate | The date the Article is set to be available.    | articleMacro | The macro of the Article.              | content | path to the Article content in .html format. | customAttributes | One or more comma-separated names for Article custom attributes defined by the user to be returned. | personalization | Article personalization details, incuding tag categories. | editions | The editions of the Article, including the publish profile (view) associated with each edition.
        :param data_destination:
        :param article_categories: Category of articles to return. All includes browsable and searchable.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.KnowledgeExport(
            article_categories=article_categories,
            portal_id=portal_id,
            language=utils.get_pydantic_model(language, models.KnowledgeExportLanguage),
            resource_types=resource_types,
            data_destination=utils.get_pydantic_model(
                data_destination, models.DataDestination
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/content/export",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.KnowledgeExport
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="exportContent",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "202", "*"):
            return models.ExportContentResponse(
                headers=utils.get_response_headers(http_res.headers)
            )
        if utils.match_response(http_res, ["400", "401"], "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def export_status(
        self,
        *,
        job_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ExportStatus:
        r"""Get Export Job Status

        ## Overview
        The Content Export Status API provides real-time status information to monitor job progress and check completion status.

        ## Status Values
        - **Pending**: Job is pending start of processing
        - **In Progress**: Job is actively processing content
        - **Completed**: Job finished successfully
        - **Failed**: Job encountered errors and could not complete

        ## Response Information
        - **Current Status**: Real-time job status
        - **Progress Metrics**: Items processed, total items
        - **Error Details**: Specific errors encountered during processing
        - **Timing Information**: Start time, estimated completion, actual completion

        ## Permission
        * Only a client application can invoke this API.


        :param job_id: **Example Usage:** ```bash GET /content/export/7A84B875-6F75-4C7B-B137-0632B62DB0BD/status ```
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ExportStatusRequest(
            job_id=job_id,
        )

        req = self._build_request(
            method="GET",
            path="/content/export/{jobID}/status",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="exportStatus",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ExportStatus, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def export_status_async(
        self,
        *,
        job_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ExportStatus:
        r"""Get Export Job Status

        ## Overview
        The Content Export Status API provides real-time status information to monitor job progress and check completion status.

        ## Status Values
        - **Pending**: Job is pending start of processing
        - **In Progress**: Job is actively processing content
        - **Completed**: Job finished successfully
        - **Failed**: Job encountered errors and could not complete

        ## Response Information
        - **Current Status**: Real-time job status
        - **Progress Metrics**: Items processed, total items
        - **Error Details**: Specific errors encountered during processing
        - **Timing Information**: Start time, estimated completion, actual completion

        ## Permission
        * Only a client application can invoke this API.


        :param job_id: **Example Usage:** ```bash GET /content/export/7A84B875-6F75-4C7B-B137-0632B62DB0BD/status ```
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ExportStatusRequest(
            job_id=job_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/content/export/{jobID}/status",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="exportStatus",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ExportStatus, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
