"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Import(BaseSDK):
    def create_import(
        self,
        *,
        data_source: Union[
            models.ImportContentDataSource, models.ImportContentDataSourceTypedDict
        ],
        operation: models.Operation,
        schedule_time: Optional[
            Union[models.ScheduleTime, models.ScheduleTimeTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateImportResponse:
        r"""Import content from external sources

        # Import Content

        ## Overview
        This API initiates a bulk content import operation from Amazon S3 buckets. It creates an asynchronous import job that processes content in the background, allowing you to import large volumes of content without blocking your application.

        ## How It Works
        1. **Job Creation**: The API creates an import job and returns a unique job ID
        2. **Content Processing**: Content is processed asynchronously in the background
        3. **Status Monitoring**: Use the job ID to monitor progress via the Status API
        4. **Completion**: Job completes when all content is processed or errors occur

        ## Supported Operations
        - **Import**: Add new content to the knowledge base
        - **Update**: Modify existing content

        ## Data Source Types
        - AWS S3 bucket
        - Shared file path

        ## Best Practices
        - **Scheduling**: Use scheduleTime for off-peak imports to minimize system impact
        - **Monitoring**: Regularly check job status and logs for any issues
        - **Error Handling**: Review failed items and retry with corrections

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<ul><li>User must be a department user.</li><li>Content can only be imported in user's home department.</li><li>User must have 'Author' role.</li><li>Content can only be imported if the user has all the required languages assigned.</li></ul>|


        :param data_source:
        :param operation:
        :param schedule_time:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.CREATE_IMPORT_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.ImportContent(
            data_source=utils.get_pydantic_model(
                data_source, models.ImportContentDataSource
            ),
            operation=operation,
            schedule_time=utils.get_pydantic_model(
                schedule_time, Optional[models.ScheduleTime]
            ),
        )

        req = self._build_request(
            method="POST",
            path="/import/content",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ImportContent
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createImport",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "406", "412", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "202", "*"):
            return models.CreateImportResponse(
                headers=utils.get_response_headers(http_res.headers)
            )
        if utils.match_response(
            http_res, ["400", "401", "403", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "412", "application/json"):
            response_data = unmarshal_json_response(
                errors.SchemasWSErrorCommonData, http_res
            )
            raise errors.SchemasWSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def create_import_async(
        self,
        *,
        data_source: Union[
            models.ImportContentDataSource, models.ImportContentDataSourceTypedDict
        ],
        operation: models.Operation,
        schedule_time: Optional[
            Union[models.ScheduleTime, models.ScheduleTimeTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateImportResponse:
        r"""Import content from external sources

        # Import Content

        ## Overview
        This API initiates a bulk content import operation from Amazon S3 buckets. It creates an asynchronous import job that processes content in the background, allowing you to import large volumes of content without blocking your application.

        ## How It Works
        1. **Job Creation**: The API creates an import job and returns a unique job ID
        2. **Content Processing**: Content is processed asynchronously in the background
        3. **Status Monitoring**: Use the job ID to monitor progress via the Status API
        4. **Completion**: Job completes when all content is processed or errors occur

        ## Supported Operations
        - **Import**: Add new content to the knowledge base
        - **Update**: Modify existing content

        ## Data Source Types
        - AWS S3 bucket
        - Shared file path

        ## Best Practices
        - **Scheduling**: Use scheduleTime for off-peak imports to minimize system impact
        - **Monitoring**: Regularly check job status and logs for any issues
        - **Error Handling**: Review failed items and retry with corrections

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<ul><li>User must be a department user.</li><li>Content can only be imported in user's home department.</li><li>User must have 'Author' role.</li><li>Content can only be imported if the user has all the required languages assigned.</li></ul>|


        :param data_source:
        :param operation:
        :param schedule_time:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.CREATE_IMPORT_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.ImportContent(
            data_source=utils.get_pydantic_model(
                data_source, models.ImportContentDataSource
            ),
            operation=operation,
            schedule_time=utils.get_pydantic_model(
                schedule_time, Optional[models.ScheduleTime]
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/import/content",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ImportContent
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createImport",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "406", "412", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "202", "*"):
            return models.CreateImportResponse(
                headers=utils.get_response_headers(http_res.headers)
            )
        if utils.match_response(
            http_res, ["400", "401", "403", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "412", "application/json"):
            response_data = unmarshal_json_response(
                errors.SchemasWSErrorCommonData, http_res
            )
            raise errors.SchemasWSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def get_import_content(
        self,
        *,
        job_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ImportStatus:
        r"""Get the current status of an import or validation job

        # Get Import Job Status

        ## Overview
        This API provides real-time status information for content import and validation operations. Use this endpoint to monitor job progress, check completion status, and access detailed logs and error information.

        ## Status Values
        - **Scheduled**: Job is queued and waiting for scheduled execution time
        - **In Progress**: Job is actively processing content
        - **Completed**: Job finished successfully
        - **Failed**: Job encountered errors and could not complete
        - **Cancelled**: Job was manually cancelled by user

        ## Response Information
        - **Current Status**: Real-time job status
        - **Progress Metrics**: Items processed, total items, completion percentage
        - **Log Files**: Location of detailed operation logs
        - **Error Details**: Specific errors encountered during processing
        - **Timing Information**: Start time, estimated completion, actual completion

        ## Log File Access
        Log files contain detailed information about:
        - Content processing steps
        - Validation results
        - Error details with context


        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<ul><li>User must be a department user.</li><li>User must have 'Author' role.</li><li>The job must have been created by the logged in user, or the logged in user must have 'View' permissions on the user who created the job.</li></ul>|


        :param job_id: **Job ID Parameter**  The unique identifier for the import or validation job. This ID was returned when the job was created via the Import or Validate API.  **Format:** UUID v4 (e.g., 7A84B875-6F75-4C7B-B137-0632B62DB0BD)  **Example Usage:** ```bash GET /import/content/7A84B875-6F75-4C7B-B137-0632B62DB0BD/status ```
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.GET_IMPORT_CONTENT_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.GetImportContentRequest(
            job_id=job_id,
        )

        req = self._build_request(
            method="GET",
            path="/import/content/{job_id}/status",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getImportContent",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ImportStatus, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_import_content_async(
        self,
        *,
        job_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ImportStatus:
        r"""Get the current status of an import or validation job

        # Get Import Job Status

        ## Overview
        This API provides real-time status information for content import and validation operations. Use this endpoint to monitor job progress, check completion status, and access detailed logs and error information.

        ## Status Values
        - **Scheduled**: Job is queued and waiting for scheduled execution time
        - **In Progress**: Job is actively processing content
        - **Completed**: Job finished successfully
        - **Failed**: Job encountered errors and could not complete
        - **Cancelled**: Job was manually cancelled by user

        ## Response Information
        - **Current Status**: Real-time job status
        - **Progress Metrics**: Items processed, total items, completion percentage
        - **Log Files**: Location of detailed operation logs
        - **Error Details**: Specific errors encountered during processing
        - **Timing Information**: Start time, estimated completion, actual completion

        ## Log File Access
        Log files contain detailed information about:
        - Content processing steps
        - Validation results
        - Error details with context


        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<ul><li>User must be a department user.</li><li>User must have 'Author' role.</li><li>The job must have been created by the logged in user, or the logged in user must have 'View' permissions on the user who created the job.</li></ul>|


        :param job_id: **Job ID Parameter**  The unique identifier for the import or validation job. This ID was returned when the job was created via the Import or Validate API.  **Format:** UUID v4 (e.g., 7A84B875-6F75-4C7B-B137-0632B62DB0BD)  **Example Usage:** ```bash GET /import/content/7A84B875-6F75-4C7B-B137-0632B62DB0BD/status ```
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.GET_IMPORT_CONTENT_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.GetImportContentRequest(
            job_id=job_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/import/content/{job_id}/status",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getImportContent",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ImportStatus, http_res)
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def create_import_validation(
        self,
        *,
        data_source: Union[
            models.ValidateImportContentDataSource,
            models.ValidateImportContentDataSourceTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateImportValidationResponse:
        r"""Validate content structure and format before import

        # Validate Import Content

        ## Overview
        This API enables users to validate content structure, format, and compliance before importing it into the production knowledge base. Validation is a non-destructive operation that checks content without making any changes to your existing data.

        ## What Validation Checks
        - **Content Structure**: Verifies required fields and data types
        - **Format Compliance**: Ensures content meets platform requirements
        - **Language Support**: Validates content against supported languages
        - **Metadata Mapping**: Checks field mappings and transformations
        - **Business Rules**: Validates against department-specific rules

        ## Validation Benefits
        - **Risk Mitigation**: Identify issues before affecting production data
        - **Quality Assurance**: Ensure content meets organizational standards
        - **Cost Savings**: Avoid failed imports that waste processing time
        - **Compliance**: Meet regulatory and internal content requirements

        ## Validation Process
        1. **Content Analysis**: System analyzes content structure and format
        2. **Rule Validation**: Applies business rules and validation logic
        3. **Quality Assessment**: Evaluates content quality and completeness
        4. **Report Generation**: Creates detailed validation report
        5. **Issue Categorization**: Classifies issues by severity and type

        ## Common Validation Issues
        - **Missing Required Fields**: Title, description, category, etc.
        - **Invalid Data Types**: Incorrect field formats (dates, numbers, etc.)
        - **Language Mismatches**: Content language not supported by department

        ## Best Practices
        - **Always Validate First**: Run validation before any import operation
        - **Review Reports**: Carefully examine validation results and warnings
        - **Fix Issues**: Address validation errors before proceeding with import
        - **Test Small Batches**: Validate with small content samples first
        - **Iterate**: Use validation feedback to improve content quality

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<ul><li>User must be a department user.</li><li>User must have 'Author' role.</li><li>Content can only be imported if the user has all the required languages assigned.</li></ul>|


        :param data_source:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.CREATE_IMPORT_VALIDATION_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.ValidateImportContent(
            data_source=utils.get_pydantic_model(
                data_source, models.ValidateImportContentDataSource
            ),
        )

        req = self._build_request(
            method="POST",
            path="/import/content/validate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ValidateImportContent
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createImportValidation",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "406", "412", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "202", "*"):
            return models.CreateImportValidationResponse(
                headers=utils.get_response_headers(http_res.headers)
            )
        if utils.match_response(
            http_res, ["400", "401", "403", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "412", "application/json"):
            response_data = unmarshal_json_response(
                errors.SchemasWSErrorCommonData, http_res
            )
            raise errors.SchemasWSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def create_import_validation_async(
        self,
        *,
        data_source: Union[
            models.ValidateImportContentDataSource,
            models.ValidateImportContentDataSourceTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateImportValidationResponse:
        r"""Validate content structure and format before import

        # Validate Import Content

        ## Overview
        This API enables users to validate content structure, format, and compliance before importing it into the production knowledge base. Validation is a non-destructive operation that checks content without making any changes to your existing data.

        ## What Validation Checks
        - **Content Structure**: Verifies required fields and data types
        - **Format Compliance**: Ensures content meets platform requirements
        - **Language Support**: Validates content against supported languages
        - **Metadata Mapping**: Checks field mappings and transformations
        - **Business Rules**: Validates against department-specific rules

        ## Validation Benefits
        - **Risk Mitigation**: Identify issues before affecting production data
        - **Quality Assurance**: Ensure content meets organizational standards
        - **Cost Savings**: Avoid failed imports that waste processing time
        - **Compliance**: Meet regulatory and internal content requirements

        ## Validation Process
        1. **Content Analysis**: System analyzes content structure and format
        2. **Rule Validation**: Applies business rules and validation logic
        3. **Quality Assessment**: Evaluates content quality and completeness
        4. **Report Generation**: Creates detailed validation report
        5. **Issue Categorization**: Classifies issues by severity and type

        ## Common Validation Issues
        - **Missing Required Fields**: Title, description, category, etc.
        - **Invalid Data Types**: Incorrect field formats (dates, numbers, etc.)
        - **Language Mismatches**: Content language not supported by department

        ## Best Practices
        - **Always Validate First**: Run validation before any import operation
        - **Review Reports**: Carefully examine validation results and warnings
        - **Fix Issues**: Address validation errors before proceeding with import
        - **Test Small Batches**: Validate with small content samples first
        - **Iterate**: Use validation feedback to improve content quality

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<ul><li>User must be a department user.</li><li>User must have 'Author' role.</li><li>Content can only be imported if the user has all the required languages assigned.</li></ul>|


        :param data_source:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.CREATE_IMPORT_VALIDATION_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.ValidateImportContent(
            data_source=utils.get_pydantic_model(
                data_source, models.ValidateImportContentDataSource
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/import/content/validate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ValidateImportContent
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createImportValidation",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "406", "412", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "202", "*"):
            return models.CreateImportValidationResponse(
                headers=utils.get_response_headers(http_res.headers)
            )
        if utils.match_response(
            http_res, ["400", "401", "403", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "412", "application/json"):
            response_data = unmarshal_json_response(
                errors.SchemasWSErrorCommonData, http_res
            )
            raise errors.SchemasWSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    def patch_import_content_validation(
        self,
        *,
        job_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Cancel an import or validation job

        # Cancel Import or Validation Job

        ## Overview
        This API allows users to cancel import or validation operations that are currently in progress or scheduled for future execution. Cancellation is immediate for scheduled jobs and graceful for running jobs.

        ## Cancellation Behavior
        - **Scheduled Jobs**: Immediate cancellation, no processing occurs
        - **In Progress Jobs**: Graceful shutdown, current item completes, no new items start
        - **Completed Jobs**: Cannot be cancelled (returns error)
        - **Failed Jobs**: Cannot be cancelled (already stopped)

        ## When to Cancel
        - **Content Issues**: Discover problems with source content
        - **Timing Changes**: Need to reschedule for different time
        - **Resource Constraints**: System resources are needed elsewhere
        - **User Request**: Manual cancellation by authorized users
        - **System Maintenance**: Planned maintenance windows

        ## Cancellation Process
        1. **Request Received**: System receives cancellation request
        2. **Status Check**: Verifies current job status
        3. **Graceful Shutdown**: For running jobs, completes current item
        4. **Resource Cleanup**: Releases allocated system resources
        5. **Status Update**: Marks job as cancelled
        6. **Notification**: Updates job status and logs

        ## Post-Cancellation
        - **Job Status**: Changes to \"Cancelled\"
        - **Partial Results**: Any completed items remain in system
        - **Logs**: Cancellation reason and timing recorded
        - **Resources**: System resources freed for other operations

        ## Best Practices
        - **Monitor Jobs**: Regularly check job status to identify candidates for cancellation
        - **Plan Cancellations**: Schedule cancellations during low-usage periods
        - **Resource Planning**: Consider resource impact before cancelling large jobs

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<li>User must be a department user.</li><li>Content can only be validated for user's home department.</li><li>User must have 'Author' role.</li><li>The job must have been created by the logged in user, or the logged in user must have 'Edit' permissions on the user who created the job.</li></ul>|


        :param job_id: **Job ID Parameter**  The unique identifier for the import or validation job. This ID was returned when the job was created via the Import or Validate API.  **Format:** UUID v4 (e.g., 7A84B875-6F75-4C7B-B137-0632B62DB0BD)  **Example Usage:** ```bash GET /import/content/7A84B875-6F75-4C7B-B137-0632B62DB0BD/status ```
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.PATCH_IMPORT_CONTENT_VALIDATION_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.PatchImportContentValidationRequest(
            job_id=job_id,
        )

        req = self._build_request(
            method="POST",
            path="/import/content/{job_id}/cancel",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patchImportContentValidation",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def patch_import_content_validation_async(
        self,
        *,
        job_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Cancel an import or validation job

        # Cancel Import or Validation Job

        ## Overview
        This API allows users to cancel import or validation operations that are currently in progress or scheduled for future execution. Cancellation is immediate for scheduled jobs and graceful for running jobs.

        ## Cancellation Behavior
        - **Scheduled Jobs**: Immediate cancellation, no processing occurs
        - **In Progress Jobs**: Graceful shutdown, current item completes, no new items start
        - **Completed Jobs**: Cannot be cancelled (returns error)
        - **Failed Jobs**: Cannot be cancelled (already stopped)

        ## When to Cancel
        - **Content Issues**: Discover problems with source content
        - **Timing Changes**: Need to reschedule for different time
        - **Resource Constraints**: System resources are needed elsewhere
        - **User Request**: Manual cancellation by authorized users
        - **System Maintenance**: Planned maintenance windows

        ## Cancellation Process
        1. **Request Received**: System receives cancellation request
        2. **Status Check**: Verifies current job status
        3. **Graceful Shutdown**: For running jobs, completes current item
        4. **Resource Cleanup**: Releases allocated system resources
        5. **Status Update**: Marks job as cancelled
        6. **Notification**: Updates job status and logs

        ## Post-Cancellation
        - **Job Status**: Changes to \"Cancelled\"
        - **Partial Results**: Any completed items remain in system
        - **Logs**: Cancellation reason and timing recorded
        - **Resources**: System resources freed for other operations

        ## Best Practices
        - **Monitor Jobs**: Regularly check job status to identify candidates for cancellation
        - **Plan Cancellations**: Schedule cancellations during low-usage periods
        - **Resource Planning**: Consider resource impact before cancelling large jobs

        ## Permissions
        | Actor | Permission |
        | ------- | --------|
        | User |<li>User must be a department user.</li><li>Content can only be validated for user's home department.</li><li>User must have 'Author' role.</li><li>The job must have been created by the logged in user, or the logged in user must have 'Edit' permissions on the user who created the job.</li></ul>|


        :param job_id: **Job ID Parameter**  The unique identifier for the import or validation job. This ID was returned when the job was created via the Import or Validate API.  **Format:** UUID v4 (e.g., 7A84B875-6F75-4C7B-B137-0632B62DB0BD)  **Example Usage:** ```bash GET /import/content/7A84B875-6F75-4C7B-B137-0632B62DB0BD/status ```
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.PATCH_IMPORT_CONTENT_VALIDATION_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.PatchImportContentValidationRequest(
            job_id=job_id,
        )

        req = self._build_request_async(
            method="POST",
            path="/import/content/{job_id}/cancel",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patchImportContentValidation",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(
            http_res, ["401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
