"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .articletype import ArticleType, ArticleTypeTypedDict
from .metadata import Metadata, MetadataTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ActionTypedDict(TypedDict):
    id: NotRequired[str]
    r"""ID of the action"""
    title: NotRequired[str]
    r"""Name of the action"""
    type: NotRequired[str]
    r"""type of the action"""
    short_name: NotRequired[str]
    r"""short name of the action"""
    reject_count: NotRequired[int]
    r"""number of times action was rejected."""
    accept_count: NotRequired[int]
    r"""number of times action was accepted."""
    metadata: NotRequired[List[MetadataTypedDict]]
    r"""Metadata of action"""
    article_type: NotRequired[ArticleTypeTypedDict]
    r"""The type of the Article and its attributes."""


class Action(BaseModel):
    id: Optional[str] = None
    r"""ID of the action"""

    title: Optional[str] = None
    r"""Name of the action"""

    type: Optional[str] = None
    r"""type of the action"""

    short_name: Annotated[Optional[str], pydantic.Field(alias="shortName")] = None
    r"""short name of the action"""

    reject_count: Annotated[Optional[int], pydantic.Field(alias="rejectCount")] = None
    r"""number of times action was rejected."""

    accept_count: Annotated[Optional[int], pydantic.Field(alias="acceptCount")] = None
    r"""number of times action was accepted."""

    metadata: Optional[List[Metadata]] = None
    r"""Metadata of action"""

    article_type: Annotated[
        Optional[ArticleType], pydantic.Field(alias="articleType")
    ] = None
    r"""The type of the Article and its attributes."""
