"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ArticleRatingTypedDict(TypedDict):
    r"""This schema contains general information about the article rating."""

    id: NotRequired[str]
    r"""The ID of the rating."""
    article_id: NotRequired[str]
    r"""The ID of the article.<br><br>An article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    rating_value: NotRequired[int]
    r"""The score value of the rating. This must be a value between 0 and 100."""
    rating_comments: NotRequired[str]
    r"""Comments about the rating."""
    user_id: NotRequired[str]
    r"""The ID of the user that rated the article."""
    rating_timestamp: NotRequired[datetime]
    r"""The timestamp for when the article was rated."""


class ArticleRating(BaseModel):
    r"""This schema contains general information about the article rating."""

    id: Optional[str] = None
    r"""The ID of the rating."""

    article_id: Annotated[Optional[str], pydantic.Field(alias="articleId")] = None
    r"""The ID of the article.<br><br>An article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    rating_value: Annotated[Optional[int], pydantic.Field(alias="ratingValue")] = None
    r"""The score value of the rating. This must be a value between 0 and 100."""

    rating_comments: Annotated[
        Optional[str], pydantic.Field(alias="ratingComments")
    ] = None
    r"""Comments about the rating."""

    user_id: Annotated[Optional[str], pydantic.Field(alias="userId")] = None
    r"""The ID of the user that rated the article."""

    rating_timestamp: Annotated[
        Optional[datetime], pydantic.Field(alias="ratingTimestamp")
    ] = None
    r"""The timestamp for when the article was rated."""
