"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .articletype import ArticleType, ArticleTypeTypedDict
from .complianceforarticle import ComplianceForArticle, ComplianceForArticleTypedDict
from .createdby import CreatedBy, CreatedByTypedDict
from .customattribute import CustomAttribute, CustomAttributeTypedDict
from .languagecode import LanguageCode
from .link import Link, LinkTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from .ownedby import OwnedBy, OwnedByTypedDict
from .personalization import Personalization, PersonalizationTypedDict
from .topicbreadcrumb import TopicBreadcrumb, TopicBreadcrumbTypedDict
from .workflow import Workflow, WorkflowTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ArticleResultTypedDict(TypedDict):
    r"""Article search result, a subset of Article that does not contain content and contentText."""

    id: NotRequired[str]
    r"""The ID of the Article.<br>An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    article_type: NotRequired[ArticleTypeTypedDict]
    r"""The type of the Article and its attributes."""
    article_keywords: NotRequired[str]
    r"""A comma-separated list of keywords associated with this Article. 1 KB max size limit."""
    article_summary: NotRequired[str]
    r"""A brief summary of the Article, provided as metadata. 1 KB max size limit."""
    average_rating: NotRequired[float]
    r"""The average rating of the Article."""
    created_by: NotRequired[CreatedByTypedDict]
    modified_by: NotRequired[ModifiedByTypedDict]
    owned_by: NotRequired[OwnedByTypedDict]
    created_date: NotRequired[str]
    custom_attributes: NotRequired[List[CustomAttributeTypedDict]]
    r"""A list of custom attributes."""
    description: NotRequired[str]
    r"""A description of the Article. The maximum allowed Article description size is 1 KB."""
    has_attachments: NotRequired[bool]
    r"""Indicates whether the Article has any attachments."""
    is_subscribed: NotRequired[bool]
    r"""Indicates whether the Article is subscribed for notifications."""
    modified_date: NotRequired[str]
    r"""The date on which the Article was last modified."""
    language_code: NotRequired[LanguageCode]
    r"""Language code of the resource's language."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""
    image_url: NotRequired[str]
    r"""The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article."""
    name: NotRequired[str]
    r"""The name of the Article."""
    times_rated: NotRequired[int]
    r"""The number of times that this Article has been rated."""
    topic_breadcrumb: NotRequired[List[TopicBreadcrumbTypedDict]]
    r"""A list of topics from the root topic to this Article. There may be multiple paths."""
    version_id: NotRequired[str]
    r"""The ID of this version of the Article."""
    workflow: NotRequired[WorkflowTypedDict]
    r"""The Article's workflow."""
    compliance: NotRequired[ComplianceForArticleTypedDict]
    r"""This schema contains the compliance details for an Article."""
    personalization: NotRequired[PersonalizationTypedDict]
    r"""Personalization allows the filtering of search results and controls the access to articles and article editions."""


class ArticleResult(BaseModel):
    r"""Article search result, a subset of Article that does not contain content and contentText."""

    id: Optional[str] = None
    r"""The ID of the Article.<br>An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    article_type: Annotated[
        Optional[ArticleType], pydantic.Field(alias="articleType")
    ] = None
    r"""The type of the Article and its attributes."""

    article_keywords: Annotated[
        Optional[str], pydantic.Field(alias="articleKeywords")
    ] = None
    r"""A comma-separated list of keywords associated with this Article. 1 KB max size limit."""

    article_summary: Annotated[
        Optional[str], pydantic.Field(alias="articleSummary")
    ] = None
    r"""A brief summary of the Article, provided as metadata. 1 KB max size limit."""

    average_rating: Annotated[
        Optional[float], pydantic.Field(alias="averageRating")
    ] = None
    r"""The average rating of the Article."""

    created_by: Annotated[Optional[CreatedBy], pydantic.Field(alias="createdBy")] = None

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    owned_by: Annotated[Optional[OwnedBy], pydantic.Field(alias="ownedBy")] = None

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None

    custom_attributes: Annotated[
        Optional[List[CustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""A list of custom attributes."""

    description: Optional[str] = None
    r"""A description of the Article. The maximum allowed Article description size is 1 KB."""

    has_attachments: Annotated[
        Optional[bool], pydantic.Field(alias="hasAttachments")
    ] = None
    r"""Indicates whether the Article has any attachments."""

    is_subscribed: Annotated[Optional[bool], pydantic.Field(alias="isSubscribed")] = (
        None
    )
    r"""Indicates whether the Article is subscribed for notifications."""

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the Article was last modified."""

    language_code: Annotated[
        Optional[LanguageCode], pydantic.Field(alias="languageCode")
    ] = None
    r"""Language code of the resource's language."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageURL")] = None
    r"""The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article."""

    name: Optional[str] = None
    r"""The name of the Article."""

    times_rated: Annotated[Optional[int], pydantic.Field(alias="timesRated")] = None
    r"""The number of times that this Article has been rated."""

    topic_breadcrumb: Annotated[
        Optional[List[TopicBreadcrumb]], pydantic.Field(alias="topicBreadcrumb")
    ] = None
    r"""A list of topics from the root topic to this Article. There may be multiple paths."""

    version_id: Annotated[Optional[str], pydantic.Field(alias="versionId")] = None
    r"""The ID of this version of the Article."""

    workflow: Optional[Workflow] = None
    r"""The Article's workflow."""

    compliance: Optional[ComplianceForArticle] = None
    r"""This schema contains the compliance details for an Article."""

    personalization: Optional[Personalization] = None
    r"""Personalization allows the filtering of search results and controls the access to articles and article editions."""
