"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .link import Link, LinkTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AttachmentContentType = Literal[
    "INTERNAL",
    "EXTERNAL",
]
r"""The type of attachment."""


class AttachmentContentTypedDict(TypedDict):
    attachment_id: NotRequired[str]
    r"""The ID of the attachment."""
    name: NotRequired[str]
    r"""The name of the attachment."""
    size: NotRequired[int]
    r"""The size of the attachment in bytes. The maximum size is limited to 25MB."""
    type: NotRequired[AttachmentContentType]
    r"""The type of attachment."""
    attachment_content_type: NotRequired[str]
    r"""The type of the content."""
    streaming_url: NotRequired[str]
    r"""The streaming URL of the attachment."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class AttachmentContent(BaseModel):
    attachment_id: Annotated[Optional[str], pydantic.Field(alias="attachmentId")] = None
    r"""The ID of the attachment."""

    name: Optional[str] = None
    r"""The name of the attachment."""

    size: Optional[int] = None
    r"""The size of the attachment in bytes. The maximum size is limited to 25MB."""

    type: Optional[AttachmentContentType] = None
    r"""The type of attachment."""

    attachment_content_type: Annotated[
        Optional[str], pydantic.Field(alias="attachmentContentType")
    ] = None
    r"""The type of the content."""

    streaming_url: Annotated[Optional[str], pydantic.Field(alias="streamingUrl")] = None
    r"""The streaming URL of the attachment."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
