"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .action import Action, ActionTypedDict
from .casequestiondetail import CaseQuestionDetail, CaseQuestionDetailTypedDict
from .createdby import CreatedBy, CreatedByTypedDict
from .link import Link, LinkTypedDict
from .metadata import Metadata, MetadataTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ThresholdType = Literal[
    "Default",
    "Custom",
]
r"""Threshold type indicating if thresholdValue is default or custom."""


CaseType = Literal[
    "Control",
    "Content",
]
r"""Type of the case. Control or Content type"""


class CaseTypedDict(TypedDict):
    r"""Success"""

    id: NotRequired[str]
    r"""The numerical ID of the case."""
    short_name: NotRequired[str]
    r"""short name of the case."""
    title: NotRequired[str]
    r"""title of the case"""
    comments: NotRequired[str]
    r"""comments on the case"""
    profile_id: NotRequired[str]
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """
    release_id: NotRequired[str]
    r"""The numerical ID of the Casebase Release in which case in created"""
    cluster_id: NotRequired[str]
    r"""ID of the cluster in which case is created"""
    created_date: NotRequired[str]
    r"""The date on which the Case was created."""
    created_by: NotRequired[CreatedByTypedDict]
    modified_by: NotRequired[ModifiedByTypedDict]
    modified_date: NotRequired[str]
    r"""The date on which the Case was last modified."""
    is_visible: NotRequired[bool]
    r"""Flag indicating if the case is visible"""
    reject_count: NotRequired[int]
    r"""number of times case was rejected."""
    accept_count: NotRequired[int]
    r"""number of times case was accepted."""
    action: NotRequired[List[ActionTypedDict]]
    r"""actions in the case"""
    metadata: NotRequired[List[MetadataTypedDict]]
    r"""Metadata of the case"""
    threshold_value: NotRequired[int]
    r"""Threshold value of the case"""
    threshold_type: NotRequired[ThresholdType]
    r"""Threshold type indicating if thresholdValue is default or custom."""
    threshold_value_from_cluster: NotRequired[float]
    r"""Threshold value of the cluster in which case is created"""
    case_type: NotRequired[CaseType]
    r"""Type of the case. Control or Content type"""
    question_detail: NotRequired[List[CaseQuestionDetailTypedDict]]
    r"""Questions in the case"""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class Case(BaseModel):
    r"""Success"""

    id: Optional[str] = None
    r"""The numerical ID of the case."""

    short_name: Annotated[Optional[str], pydantic.Field(alias="shortName")] = None
    r"""short name of the case."""

    title: Optional[str] = None
    r"""title of the case"""

    comments: Optional[str] = None
    r"""comments on the case"""

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """

    release_id: Annotated[Optional[str], pydantic.Field(alias="releaseId")] = None
    r"""The numerical ID of the Casebase Release in which case in created"""

    cluster_id: Annotated[Optional[str], pydantic.Field(alias="clusterId")] = None
    r"""ID of the cluster in which case is created"""

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None
    r"""The date on which the Case was created."""

    created_by: Annotated[Optional[CreatedBy], pydantic.Field(alias="createdBy")] = None

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the Case was last modified."""

    is_visible: Annotated[Optional[bool], pydantic.Field(alias="isVisible")] = None
    r"""Flag indicating if the case is visible"""

    reject_count: Annotated[Optional[int], pydantic.Field(alias="rejectCount")] = None
    r"""number of times case was rejected."""

    accept_count: Annotated[Optional[int], pydantic.Field(alias="acceptCount")] = None
    r"""number of times case was accepted."""

    action: Optional[List[Action]] = None
    r"""actions in the case"""

    metadata: Optional[List[Metadata]] = None
    r"""Metadata of the case"""

    threshold_value: Annotated[
        Optional[int], pydantic.Field(alias="thresholdValue")
    ] = None
    r"""Threshold value of the case"""

    threshold_type: Annotated[
        Optional[ThresholdType], pydantic.Field(alias="thresholdType")
    ] = None
    r"""Threshold type indicating if thresholdValue is default or custom."""

    threshold_value_from_cluster: Annotated[
        Optional[float], pydantic.Field(alias="thresholdValueFromCluster")
    ] = None
    r"""Threshold value of the cluster in which case is created"""

    case_type: Annotated[Optional[CaseType], pydantic.Field(alias="caseType")] = None
    r"""Type of the case. Control or Content type"""

    question_detail: Annotated[
        Optional[List[CaseQuestionDetail]], pydantic.Field(alias="questionDetail")
    ] = None
    r"""Questions in the case"""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
