"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .action import Action, ActionTypedDict
from .metadata import Metadata, MetadataTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


CaseSearchType = Literal[
    "Control",
    "Article",
]
r"""The type of the action"""


class CaseSearchTypedDict(TypedDict):
    accept_count: NotRequired[int]
    r"""The number of times action was accepted"""
    action: NotRequired[List[ActionTypedDict]]
    r"""actions in search"""
    additional_info: NotRequired[bool]
    r"""This field indicates if action has additional information"""
    metadata: NotRequired[List[MetadataTypedDict]]
    r"""Metadata in search"""
    case_id: NotRequired[str]
    r"""case Id"""
    passed_threshold_value: NotRequired[bool]
    r"""This field indicates if the case has passed the threshold value"""
    reject_count: NotRequired[int]
    r"""The number of times action was rejected"""
    short_name: NotRequired[str]
    r"""The short name"""
    score: NotRequired[float]
    r"""The score of the case"""
    title: NotRequired[str]
    r"""The title of the case"""
    type: NotRequired[CaseSearchType]
    r"""The type of the action"""


class CaseSearch(BaseModel):
    accept_count: Annotated[Optional[int], pydantic.Field(alias="acceptCount")] = None
    r"""The number of times action was accepted"""

    action: Optional[List[Action]] = None
    r"""actions in search"""

    additional_info: Annotated[
        Optional[bool], pydantic.Field(alias="additionalInfo")
    ] = None
    r"""This field indicates if action has additional information"""

    metadata: Optional[List[Metadata]] = None
    r"""Metadata in search"""

    case_id: Annotated[Optional[str], pydantic.Field(alias="caseId")] = None
    r"""case Id"""

    passed_threshold_value: Annotated[
        Optional[bool], pydantic.Field(alias="passedThresholdValue")
    ] = None
    r"""This field indicates if the case has passed the threshold value"""

    reject_count: Annotated[Optional[int], pydantic.Field(alias="rejectCount")] = None
    r"""The number of times action was rejected"""

    short_name: Annotated[Optional[str], pydantic.Field(alias="shortName")] = None
    r"""The short name"""

    score: Optional[float] = None
    r"""The score of the case"""

    title: Optional[str] = None
    r"""The title of the case"""

    type: Optional[CaseSearchType] = None
    r"""The type of the action"""
