"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .link import Link, LinkTypedDict
from .publishprofile import PublishProfile, PublishProfileTypedDict
from .schemas_tagcategory import SchemasTagCategory, SchemasTagCategoryTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EditionWithContentAccessTagsTypedDict(TypedDict):
    tag_category: NotRequired[List[SchemasTagCategoryTypedDict]]
    r"""An array of tag categories. Note that the total number of tag categories cannot exceed 20."""


class EditionWithContentAccessTags(BaseModel):
    tag_category: Annotated[
        Optional[List[SchemasTagCategory]], pydantic.Field(alias="tagCategory")
    ] = None
    r"""An array of tag categories. Note that the total number of tag categories cannot exceed 20."""


class EditionWithContentTypedDict(TypedDict):
    r"""This schema contains information about article edition."""

    id: NotRequired[str]
    r"""ID of the edition."""
    name: NotRequired[str]
    r"""Name of the edition."""
    publish_profile: NotRequired[PublishProfileTypedDict]
    r"""This schema contains information about Profile."""
    content: NotRequired[str]
    r"""The raw content of the article. The maximum allowed Article content size is 5 MB."""
    content_text: NotRequired[str]
    r"""Plain text version of the content. The maximum allowed Article content size is 5 MB."""
    access_tags: NotRequired[EditionWithContentAccessTagsTypedDict]
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class EditionWithContent(BaseModel):
    r"""This schema contains information about article edition."""

    id: Optional[str] = None
    r"""ID of the edition."""

    name: Optional[str] = None
    r"""Name of the edition."""

    publish_profile: Annotated[
        Optional[PublishProfile], pydantic.Field(alias="publishProfile")
    ] = None
    r"""This schema contains information about Profile."""

    content: Optional[str] = None
    r"""The raw content of the article. The maximum allowed Article content size is 5 MB."""

    content_text: Annotated[Optional[str], pydantic.Field(alias="contentText")] = None
    r"""Plain text version of the content. The maximum allowed Article content size is 5 MB."""

    access_tags: Annotated[
        Optional[EditionWithContentAccessTags], pydantic.Field(alias="accessTags")
    ] = None

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
