"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ImportContentType = Literal[
    "AWS S3 bucket",
    "Shared file path",
]
r"""Type of data source"""


class ImportContentCredentialsTypedDict(TypedDict):
    access_key: NotRequired[str]
    secret_key: NotRequired[str]


class ImportContentCredentials(BaseModel):
    access_key: Annotated[Optional[str], pydantic.Field(alias="accessKey")] = None

    secret_key: Annotated[Optional[str], pydantic.Field(alias="secretKey")] = None


class ImportContentDataSourceTypedDict(TypedDict):
    type: ImportContentType
    r"""Type of data source"""
    path: str
    r"""Path of the data source"""
    region: NotRequired[str]
    r"""Region of the data source"""
    credentials: NotRequired[ImportContentCredentialsTypedDict]


class ImportContentDataSource(BaseModel):
    type: ImportContentType
    r"""Type of data source"""

    path: str
    r"""Path of the data source"""

    region: Optional[str] = None
    r"""Region of the data source"""

    credentials: Optional[ImportContentCredentials] = None


Operation = Literal[
    "import",
    "reimport",
]


class ScheduleTimeTypedDict(TypedDict):
    date_: datetime


class ScheduleTime(BaseModel):
    date_: Annotated[datetime, pydantic.Field(alias="date")]


class ImportContentTypedDict(TypedDict):
    data_source: ImportContentDataSourceTypedDict
    operation: Operation
    schedule_time: NotRequired[ScheduleTimeTypedDict]


class ImportContent(BaseModel):
    data_source: Annotated[ImportContentDataSource, pydantic.Field(alias="dataSource")]

    operation: Operation

    schedule_time: Annotated[
        Optional[ScheduleTime], pydantic.Field(alias="scheduleTime")
    ] = None
