"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .contacts import Contacts, ContactsTypedDict
from egain_api_python.types import BaseModel
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


class CustomerTypedDict(TypedDict):
    r"""The contact point details of the customer who is starting the escalation."""

    contacts: NotRequired[ContactsTypedDict]
    r"""Contacts"""


class Customer(BaseModel):
    r"""The contact point details of the customer who is starting the escalation."""

    contacts: Optional[Contacts] = None
    r"""Contacts"""


ChannelEnum = Literal["email",]
r"""The type of escalation

"""


class CaptchaTypedDict(TypedDict):
    r"""Only required when captcha is enabled for portal."""

    response: str


class Captcha(BaseModel):
    r"""Only required when captcha is enabled for portal."""

    response: str


class StartEscalationRequestTypedDict(TypedDict):
    subject: str
    r"""The subject of the email message.

    """
    body: str
    r"""The body of the email message.

    """
    channel: ChannelEnum
    r"""The type of escalation

    """
    url: str
    r"""The url of the page that the customer was viewing at the time when the ecalation started.

    """
    customer: NotRequired[CustomerTypedDict]
    r"""The contact point details of the customer who is starting the escalation."""
    captcha: NotRequired[CaptchaTypedDict]
    r"""Only required when captcha is enabled for portal.

    """


class StartEscalationRequest(BaseModel):
    subject: str
    r"""The subject of the email message.

    """

    body: str
    r"""The body of the email message.

    """

    channel: ChannelEnum
    r"""The type of escalation

    """

    url: str
    r"""The url of the page that the customer was viewing at the time when the ecalation started.

    """

    customer: Optional[Customer] = None
    r"""The contact point details of the customer who is starting the escalation."""

    captcha: Optional[Captcha] = None
    r"""Only required when captcha is enabled for portal.

    """
