"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customattribute import CustomAttribute, CustomAttributeTypedDict
from .link import Link, LinkTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SuggestionL10NStringTypedDict(TypedDict):
    r"""The status of the Suggestion.
    <li>1 : suggested.</li>
    <li>2 : pending</li>
    <li>3 : declined</li>
    <li>4 : approved</li>
    """

    value: NotRequired[str]
    r"""A string that indicates the value."""
    display_value: NotRequired[str]
    r"""Localized string of the value element."""


class SuggestionL10NString(BaseModel):
    r"""The status of the Suggestion.
    <li>1 : suggested.</li>
    <li>2 : pending</li>
    <li>3 : declined</li>
    <li>4 : approved</li>
    """

    value: Optional[str] = None
    r"""A string that indicates the value."""

    display_value: Annotated[Optional[str], pydantic.Field(alias="displayValue")] = None
    r"""Localized string of the value element."""


SuggestionCode = Literal[
    "en-US",
    "en-GB",
    "fr-FR",
    "es-ES",
    "it-IT",
    "de-DE",
    "nl-NL",
    "pt-BR",
    "pt-PT",
    "da-DK",
    "sv-SE",
    "ru-RU",
    "fr-CA",
    "zh-CN",
    "ja-JP",
    "ko-KR",
]
r"""The language that describes the details of the resource. Resources available in different languages may differ from each other."""


Label = Literal[
    "English",
    "French",
    "Spanish",
    "Italian",
    "German",
    "Dutch",
    "Portuguese",
    "Danish",
    "Swedish",
    "Russian",
    "Chinese",
    "Japanese",
    "Korean",
]
r"""The name of the language."""


class SuggestionLanguageTypedDict(TypedDict):
    r"""The knowledge base language in which the Suggestion was created."""

    code: SuggestionCode
    r"""The language that describes the details of the resource. Resources available in different languages may differ from each other."""
    label: NotRequired[Label]
    r"""The name of the language."""


class SuggestionLanguage(BaseModel):
    r"""The knowledge base language in which the Suggestion was created."""

    code: SuggestionCode
    r"""The language that describes the details of the resource. Resources available in different languages may differ from each other."""

    label: Optional[Label] = None
    r"""The name of the language."""


class SuggestionTypedDict(TypedDict):
    r"""This schema contains information about a Suggestion."""

    id: str
    r"""The ID of the Suggestion. A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    name: str
    r"""The name of the Suggestion."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""
    description: NotRequired[str]
    r"""The description of the Suggestion."""
    content: NotRequired[str]
    r"""The content of the Suggestion."""
    has_related_articles: NotRequired[bool]
    r"""If true, the Suggestion has one or more Related Articles."""
    status: NotRequired[SuggestionL10NStringTypedDict]
    r"""The status of the Suggestion.
    <li>1 : suggested.</li>
    <li>2 : pending</li>
    <li>3 : declined</li>
    <li>4 : approved</li>
    """
    modified_by: NotRequired[ModifiedByTypedDict]
    modified_date: NotRequired[datetime]
    r"""The last modified date and last modifying user of the Suggestion."""
    has_attachments: NotRequired[bool]
    r"""Indicates whether the Suggestion has any Attachments."""
    has_comments: NotRequired[bool]
    r"""Indicates whether the Suggestion has any comments."""
    language: NotRequired[SuggestionLanguageTypedDict]
    r"""The knowledge base language in which the Suggestion was created."""
    custom_attributes: NotRequired[List[CustomAttributeTypedDict]]
    r"""Custom Attributes of the Suggestion."""


class Suggestion(BaseModel):
    r"""This schema contains information about a Suggestion."""

    id: str
    r"""The ID of the Suggestion. A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    name: str
    r"""The name of the Suggestion."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""

    description: Optional[str] = None
    r"""The description of the Suggestion."""

    content: Optional[str] = None
    r"""The content of the Suggestion."""

    has_related_articles: Annotated[
        Optional[bool], pydantic.Field(alias="hasRelatedArticles")
    ] = None
    r"""If true, the Suggestion has one or more Related Articles."""

    status: Optional[SuggestionL10NString] = None
    r"""The status of the Suggestion.
    <li>1 : suggested.</li>
    <li>2 : pending</li>
    <li>3 : declined</li>
    <li>4 : approved</li>
    """

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    modified_date: Annotated[
        Optional[datetime], pydantic.Field(alias="modifiedDate")
    ] = None
    r"""The last modified date and last modifying user of the Suggestion."""

    has_attachments: Annotated[
        Optional[bool], pydantic.Field(alias="hasAttachments")
    ] = None
    r"""Indicates whether the Suggestion has any Attachments."""

    has_comments: Annotated[Optional[bool], pydantic.Field(alias="hasComments")] = None
    r"""Indicates whether the Suggestion has any comments."""

    language: Optional[SuggestionLanguage] = None
    r"""The knowledge base language in which the Suggestion was created."""

    custom_attributes: Annotated[
        Optional[List[CustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""Custom Attributes of the Suggestion."""
