"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .role import Role, RoleTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UserDetailsTypedDict(TypedDict):
    r"""Success"""

    id: NotRequired[str]
    r"""The numerical ID of the User"""
    roles: NotRequired[List[RoleTypedDict]]
    r"""Roles of the User"""
    first_name: NotRequired[str]
    r"""First Name of the User"""
    last_name: NotRequired[str]
    r"""Last Name of the User"""
    has_email_configured: NotRequired[bool]
    r"""Indicates if user has email"""


class UserDetails(BaseModel):
    r"""Success"""

    id: Optional[str] = None
    r"""The numerical ID of the User"""

    roles: Optional[List[Role]] = None
    r"""Roles of the User"""

    first_name: Annotated[Optional[str], pydantic.Field(alias="firstName")] = None
    r"""First Name of the User"""

    last_name: Annotated[Optional[str], pydantic.Field(alias="lastName")] = None
    r"""Last Name of the User"""

    has_email_configured: Annotated[
        Optional[bool], pydantic.Field(alias="hasEmailConfigured")
    ] = None
    r"""Indicates if user has email"""
