"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Dict, List, Mapping, Optional, Union


class Answers(BaseSDK):
    def get_best_answer(
        self,
        *,
        q: str,
        portal_id: str,
        filter_user_profile_id: Optional[str] = None,
        language: Optional[models.LanguageCodeParameter] = None,
        filter_tags: Optional[Dict[str, List[str]]] = None,
        filter_topic_ids: Optional[List[str]] = None,
        channel: Optional[
            Union[models.AnswersRequestChannel, models.AnswersRequestChannelTypedDict]
        ] = None,
        context: Optional[Union[models.Context, models.ContextTypedDict]] = None,
        event_id: Optional[str] = None,
        session_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnswersResponse:
        r"""Get the best answer for a user query

        The **Answers API** allows enterprises to deliver fast, accurate, and contextual responses powered by their organizational knowledge. It supports two complementary approaches:
        <li> **Certified Answers**: Direct snippets retrieved from enterprise-authored content. </li>
        <li> **Generative Answers**: Natural language responses synthesized by a large language model (LLM).  </li>

        Every response includes supporting search results, references, and confidence scores—ensuring transparency, trust, and traceability. The API is built for secure, scalable integration across enterprise environments.


        :param q: The search query string. The string must be escaped as required by the URL syntax rules.
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param filter_user_profile_id:
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other. <br><br> If lang is not passed, then the portal's default language is used.
        :param filter_tags: An object where each key is a **Category Tag ID** (numeric string),   and each value is an array of **Tag IDs** for that category.
        :param filter_topic_ids: An array of topic IDs. It is used to restrict search results to specific topics.
        :param channel:
        :param context: Additional contextual metadata that enriches the query, providing the LLM with relevant details for tailoring the response.
        :param event_id: Unique ID for this specific API call or event.
        :param session_id: ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.GET_BEST_ANSWER_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.GetBestAnswerRequest(
            q=q,
            portal_id=portal_id,
            filter_user_profile_id=filter_user_profile_id,
            language=language,
            filter_tags=filter_tags,
            filter_topic_ids=filter_topic_ids,
            answers_request=models.AnswersRequest(
                channel=utils.get_pydantic_model(
                    channel, Optional[models.AnswersRequestChannel]
                ),
                context=utils.get_pydantic_model(context, Optional[models.Context]),
                event_id=event_id,
                session_id=session_id,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/{portalID}/answers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.answers_request,
                False,
                True,
                "json",
                Optional[models.AnswersRequest],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getBestAnswer",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AnswersResponse, http_res)
        if utils.match_response(http_res, ["400", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, ["500", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def get_best_answer_async(
        self,
        *,
        q: str,
        portal_id: str,
        filter_user_profile_id: Optional[str] = None,
        language: Optional[models.LanguageCodeParameter] = None,
        filter_tags: Optional[Dict[str, List[str]]] = None,
        filter_topic_ids: Optional[List[str]] = None,
        channel: Optional[
            Union[models.AnswersRequestChannel, models.AnswersRequestChannelTypedDict]
        ] = None,
        context: Optional[Union[models.Context, models.ContextTypedDict]] = None,
        event_id: Optional[str] = None,
        session_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnswersResponse:
        r"""Get the best answer for a user query

        The **Answers API** allows enterprises to deliver fast, accurate, and contextual responses powered by their organizational knowledge. It supports two complementary approaches:
        <li> **Certified Answers**: Direct snippets retrieved from enterprise-authored content. </li>
        <li> **Generative Answers**: Natural language responses synthesized by a large language model (LLM).  </li>

        Every response includes supporting search results, references, and confidence scores—ensuring transparency, trust, and traceability. The API is built for secure, scalable integration across enterprise environments.


        :param q: The search query string. The string must be escaped as required by the URL syntax rules.
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param filter_user_profile_id:
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other. <br><br> If lang is not passed, then the portal's default language is used.
        :param filter_tags: An object where each key is a **Category Tag ID** (numeric string),   and each value is an array of **Tag IDs** for that category.
        :param filter_topic_ids: An array of topic IDs. It is used to restrict search results to specific topics.
        :param channel:
        :param context: Additional contextual metadata that enriches the query, providing the LLM with relevant details for tailoring the response.
        :param event_id: Unique ID for this specific API call or event.
        :param session_id: ID that ties multiple API calls to the same user session. Will be used as part of to tie events back to a session.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.GET_BEST_ANSWER_OP_SERVERS[0]
            url_variables = {
                "API_DOMAIN": "api.egain.cloud",
            }

        request = models.GetBestAnswerRequest(
            q=q,
            portal_id=portal_id,
            filter_user_profile_id=filter_user_profile_id,
            language=language,
            filter_tags=filter_tags,
            filter_topic_ids=filter_topic_ids,
            answers_request=models.AnswersRequest(
                channel=utils.get_pydantic_model(
                    channel, Optional[models.AnswersRequestChannel]
                ),
                context=utils.get_pydantic_model(context, Optional[models.Context]),
                event_id=event_id,
                session_id=session_id,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/{portalID}/answers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.answers_request,
                False,
                True,
                "json",
                Optional[models.AnswersRequest],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getBestAnswer",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AnswersResponse, http_res)
        if utils.match_response(http_res, ["400", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, ["500", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
