"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .link import Link, LinkTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EditionPublishProfileTypedDict(TypedDict):
    r"""The publish view associated with this edition."""

    id: str
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """
    name: str
    r"""The name of the profile."""


class EditionPublishProfile(BaseModel):
    r"""The publish view associated with this edition."""

    id: str
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """

    name: str
    r"""The name of the profile."""


class EditionTypedDict(TypedDict):
    r"""This schema contains information about an article edition."""

    id: NotRequired[str]
    r"""The ID of the article edition.<br>An edition ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits."""
    name: NotRequired[str]
    r"""The alphanumeric name of the edition."""
    is_content_edition: NotRequired[bool]
    r"""<li>The presence of this element indicates that this edition is the one corresponding to the returned content.</li>
    <li>This can only be true for at most one <edition> element in the list of editions.</li>
    <li>This parameter must only be returned if article content is returned as well.</li>
    <li>The only allowed value is *true*. The absence of this parameter in the response indicates *false*.</li>
    """
    publish_profile: NotRequired[EditionPublishProfileTypedDict]
    r"""The publish view associated with this edition."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""


class Edition(BaseModel):
    r"""This schema contains information about an article edition."""

    id: Optional[str] = None
    r"""The ID of the article edition.<br>An edition ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits."""

    name: Optional[str] = None
    r"""The alphanumeric name of the edition."""

    is_content_edition: Annotated[
        Optional[bool], pydantic.Field(alias="isContentEdition")
    ] = None
    r"""<li>The presence of this element indicates that this edition is the one corresponding to the returned content.</li>
    <li>This can only be true for at most one <edition> element in the list of editions.</li>
    <li>This parameter must only be returned if article content is returned as well.</li>
    <li>The only allowed value is *true*. The absence of this parameter in the response indicates *false*.</li>
    """

    publish_profile: Annotated[
        Optional[EditionPublishProfile], pydantic.Field(alias="publishProfile")
    ] = None
    r"""The publish view associated with this edition."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""
