"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .languagequeryparameter import LanguageQueryParameter
from .topicadditionalattributes import TopicAdditionalAttributes
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetalltopicsRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    level: NotRequired[int]
    r"""Depth of the topic hierarchy to be returned in the response."""
    language: NotRequired[LanguageQueryParameter]
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>"""
    topic_additional_attributes: NotRequired[List[TopicAdditionalAttributes]]
    r"""The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.

    #### Default Attributes
    These topic attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the topic.
    | name  | The name of the topic.
    | articleCountInTopic | Number of articles in this topic.
    | articleCountInTopicTree  | Number of articles in this topic and all sub-topics.
    | createdBy.id | The ID of the user that created the topic.
    | createdDate | The date when the topic was created.
    | departmentId | ID of the department for which this topic belongs to.
    | topicHomeArticleId | The ID of the article used as the home page of this topic.
    | modifiedBy.id | The ID of the user that last modified the topic.
    | modifiedDate | The date when the topic was last modified on.
    | childCount | Total number of children sub-topis below the current topic
    | subTopicIds | Array with the list of sub-topics
    | parentTopicId | ID of the parent topic. -1 if it is the root topic.

    """
    custom_additional_attributes: NotRequired[str]
    pagenum: NotRequired[int]
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""
    pagesize: NotRequired[int]
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum."""


class GetalltopicsRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    level: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Depth of the topic hierarchy to be returned in the response."""

    language: Annotated[
        Optional[LanguageQueryParameter],
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>"""

    topic_additional_attributes: Annotated[
        Optional[List[TopicAdditionalAttributes]],
        pydantic.Field(alias="topicAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The attributes of a topic to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.

    #### Default Attributes
    These topic attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the topic.
    | name  | The name of the topic.
    | articleCountInTopic | Number of articles in this topic.
    | articleCountInTopicTree  | Number of articles in this topic and all sub-topics.
    | createdBy.id | The ID of the user that created the topic.
    | createdDate | The date when the topic was created.
    | departmentId | ID of the department for which this topic belongs to.
    | topicHomeArticleId | The ID of the article used as the home page of this topic.
    | modifiedBy.id | The ID of the user that last modified the topic.
    | modifiedDate | The date when the topic was last modified on.
    | childCount | Total number of children sub-topis below the current topic
    | subTopicIds | Array with the list of sub-topics
    | parentTopicId | ID of the parent topic. -1 if it is the root topic.

    """

    custom_additional_attributes: Annotated[
        Optional[str],
        pydantic.Field(alias="$customAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    pagenum: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagenum"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize."""

    pagesize: Annotated[
        Optional[int],
        pydantic.Field(alias="$pagesize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum."""
