"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .questionandanswer import QuestionAndAnswer, QuestionAndAnswerTypedDict
from .sessioncontextvariable import (
    SessionContextVariable,
    SessionContextVariableTypedDict,
)
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GHStepSearchRequestTypedDict(TypedDict):
    casebase_id: str
    r"""The numerical ID of the Casebase."""
    questions: List[QuestionAndAnswerTypedDict]
    r"""Pre-answered Questions in Guided Help search"""
    profile_id: NotRequired[str]
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """
    session_variable: NotRequired[List[SessionContextVariableTypedDict]]
    r"""Session variables used to give Guided Help additional context."""
    start_over: NotRequired[bool]
    r"""Restart the current Guided Help search with the existing context along with session variable context."""
    use_live_release: NotRequired[bool]
    r"""Use current live release snapshot of the Casebase otherwise use the authoring release."""
    ghs_article_id: NotRequired[str]
    r"""Numeric ID of the guided help session article used for starting search."""


class GHStepSearchRequest(BaseModel):
    casebase_id: Annotated[str, pydantic.Field(alias="casebaseId")]
    r"""The numerical ID of the Casebase."""

    questions: List[QuestionAndAnswer]
    r"""Pre-answered Questions in Guided Help search"""

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The ID of the guided help profile.<br>
    1 will always be the **system profile**.

    """

    session_variable: Annotated[
        Optional[List[SessionContextVariable]], pydantic.Field(alias="sessionVariable")
    ] = None
    r"""Session variables used to give Guided Help additional context."""

    start_over: Annotated[Optional[bool], pydantic.Field(alias="startOver")] = None
    r"""Restart the current Guided Help search with the existing context along with session variable context."""

    use_live_release: Annotated[
        Optional[bool], pydantic.Field(alias="useLiveRelease")
    ] = None
    r"""Use current live release snapshot of the Casebase otherwise use the authoring release."""

    ghs_article_id: Annotated[Optional[str], pydantic.Field(alias="ghsArticleId")] = (
        None
    )
    r"""Numeric ID of the guided help session article used for starting search."""
