"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ImportStatusStatus = Literal[
    "Scheduled",
    "In Progress",
    "Successful",
    "Failed",
    "Cancelled",
]
r"""Status of the job."""


JobType = Literal[
    "Import",
    "Validation",
]


class ImportStatusProgressTypedDict(TypedDict):
    r"""Progress of the job."""

    processed: NotRequired[float]
    r"""Number of items processed."""
    total: NotRequired[float]
    r"""Number of total items to process."""
    percentage: NotRequired[float]
    r"""Percentage of total items that have been processed."""


class ImportStatusProgress(BaseModel):
    r"""Progress of the job."""

    processed: Optional[float] = None
    r"""Number of items processed."""

    total: Optional[float] = None
    r"""Number of total items to process."""

    percentage: Optional[float] = None
    r"""Percentage of total items that have been processed."""


class ImportStatusResultsTypedDict(TypedDict):
    r"""Result of job."""

    succesfull: NotRequired[float]
    r"""Number of item succesfully processed by job."""
    warnings: NotRequired[float]
    r"""Number of warnings encountered during job."""
    errors: NotRequired[float]
    r"""Number of errors encountered during job."""


class ImportStatusResults(BaseModel):
    r"""Result of job."""

    succesfull: Optional[float] = None
    r"""Number of item succesfully processed by job."""

    warnings: Optional[float] = None
    r"""Number of warnings encountered during job."""

    errors: Optional[float] = None
    r"""Number of errors encountered during job."""


class ImportStatusTypedDict(TypedDict):
    status: ImportStatusStatus
    r"""Status of the job."""
    job_type: JobType
    progress: NotRequired[ImportStatusProgressTypedDict]
    r"""Progress of the job."""
    log_file_location: NotRequired[str]
    r"""Location of the job log file."""
    start_time: NotRequired[datetime]
    r"""Start time of job."""
    estimated_completion: NotRequired[datetime]
    r"""Estimated completion time of job."""
    current_operation: NotRequired[str]
    r"""Current operation of job being processed."""
    completion_time: NotRequired[datetime]
    r"""Completion time of job."""
    failure_time: NotRequired[datetime]
    r"""Failure time of job."""
    results: NotRequired[ImportStatusResultsTypedDict]
    r"""Result of job."""
    error: NotRequired[str]
    r"""Error of job."""
    retryable: NotRequired[bool]
    r"""Indicates if job is retryable."""


class ImportStatus(BaseModel):
    status: ImportStatusStatus
    r"""Status of the job."""

    job_type: Annotated[JobType, pydantic.Field(alias="jobType")]

    progress: Optional[ImportStatusProgress] = None
    r"""Progress of the job."""

    log_file_location: Annotated[
        Optional[str], pydantic.Field(alias="logFileLocation")
    ] = None
    r"""Location of the job log file."""

    start_time: Annotated[Optional[datetime], pydantic.Field(alias="startTime")] = None
    r"""Start time of job."""

    estimated_completion: Annotated[
        Optional[datetime], pydantic.Field(alias="estimatedCompletion")
    ] = None
    r"""Estimated completion time of job."""

    current_operation: Annotated[
        Optional[str], pydantic.Field(alias="currentOperation")
    ] = None
    r"""Current operation of job being processed."""

    completion_time: Annotated[
        Optional[datetime], pydantic.Field(alias="completionTime")
    ] = None
    r"""Completion time of job."""

    failure_time: Annotated[Optional[datetime], pydantic.Field(alias="failureTime")] = (
        None
    )
    r"""Failure time of job."""

    results: Optional[ImportStatusResults] = None
    r"""Result of job."""

    error: Optional[str] = None
    r"""Error of job."""

    retryable: Optional[bool] = None
    r"""Indicates if job is retryable."""
