"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from egain_api_python import errors, models, utils
from egain_api_python._hooks import HookContext
from egain_api_python.types import OptionalNullable, UNSET
from egain_api_python.utils import get_security_from_env
from egain_api_python.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional


class Populararticles(BaseSDK):
    def getpopulararticles(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        filter_topic_id: Optional[str] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        filter_tags: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Popular Articles

        ## Overview
        The Popular Articles API allows a user to retrieve popular articles.
        ## Prerequisites
        * Only displayable articles are returned. An Article is displayable when \"Include in browse on portals\" property is enable for the Article.
        ## Permissions
        * Agent permissions: The following permissions are required if user is an Agent:
        * If Article has Access Tags, Article must be available for agent's current user profile.
        * If Article has Publish Views, at least one edition of Article must be available for agent's current user profile.
        * If Article has filters and tags query parameter provided, Article filters must match provided tags or tag groups.
        * Customer permissions: The following permissions are required if user is a Customer:
        * If Article has Access tags:
        * Portal must have default user profile, and;
        * Article must be available for portal's default user profile.
        * If Article has Publish Views:
        * Portal must have default user profile, and;
        * At least one edition must be available for portal's default user profile.
        *  If Article has filters and tags query parameter provided, Article filters must match provided tags or tag groups.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param filter_topic_id: The ID of the topic. It is used to restrict to a specific topic.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetpopulararticlesRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            filter_topic_id=filter_topic_id,
            language=language,
            filter_tags=filter_tags,
            pagenum=pagenum,
            pagesize=pagesize,
            article_result_additional_attributes=article_result_additional_attributes,
        )

        req = self._build_request(
            method="GET",
            path="/portals/{portalID}/populararticles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getpopulararticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)

    async def getpopulararticles_async(
        self,
        *,
        accept_language: models.AcceptLanguage,
        portal_id: str,
        filter_topic_id: Optional[str] = None,
        language: Optional[models.LanguageQueryParameter] = None,
        filter_tags: Optional[str] = None,
        pagenum: Optional[int] = 1,
        pagesize: Optional[int] = 10,
        article_result_additional_attributes: Optional[
            List[models.ArticleResultAdditionalAttributes]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ArticleResults]:
        r"""Get Popular Articles

        ## Overview
        The Popular Articles API allows a user to retrieve popular articles.
        ## Prerequisites
        * Only displayable articles are returned. An Article is displayable when \"Include in browse on portals\" property is enable for the Article.
        ## Permissions
        * Agent permissions: The following permissions are required if user is an Agent:
        * If Article has Access Tags, Article must be available for agent's current user profile.
        * If Article has Publish Views, at least one edition of Article must be available for agent's current user profile.
        * If Article has filters and tags query parameter provided, Article filters must match provided tags or tag groups.
        * Customer permissions: The following permissions are required if user is a Customer:
        * If Article has Access tags:
        * Portal must have default user profile, and;
        * Article must be available for portal's default user profile.
        * If Article has Publish Views:
        * Portal must have default user profile, and;
        * At least one edition must be available for portal's default user profile.
        *  If Article has filters and tags query parameter provided, Article filters must match provided tags or tag groups.


        :param accept_language: The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses).
        :param portal_id: The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits.
        :param filter_topic_id: The ID of the topic. It is used to restrict to a specific topic.
        :param language: The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>
        :param filter_tags: A comma separated list of Tag / Tag Group IDs. The query results will be filtered by the tags that are specified.<br><br>Tag IDs and Tag Group IDs can be mixed together.
        :param pagenum: Pagination parameter that specifies the page number of results to be returned. Used in conjunction with $pagesize.
        :param pagesize: Pagination parameter that specifies the number of results per page. Used in conjunction with $pagenum.
        :param article_result_additional_attributes: The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.  #### Default Attributes These Article attributes are always returned:  | Name | Description  | ---- | ----------- | id | The ID of the Article. | name  | The name of the Article. | articleType | The Article Type and its attributes. | createdBy | The ID, first name, middle name and last name of the user that created the Article. | createdDate | The date that the Article was created. | hasAttachments | True: The Article has one or more attachments.<br>False: The Article does not have any attachments. | languageCode | The language code of the Article language.  | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article. | modifiedDate | The date that the Article was last modified on. | link | The link object, used to retrieve the details of the Article. | versionId | The ID of the Article version that is returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetpopulararticlesRequest(
            accept_language=accept_language,
            portal_id=portal_id,
            filter_topic_id=filter_topic_id,
            language=language,
            filter_tags=filter_tags,
            pagenum=pagenum,
            pagesize=pagesize,
            article_result_additional_attributes=article_result_additional_attributes,
        )

        req = self._build_request_async(
            method="GET",
            path="/portals/{portalID}/populararticles",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="getpopulararticles",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "406", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ArticleResults, http_res)
        if utils.match_response(http_res, "204", "*"):
            return None
        if utils.match_response(
            http_res, ["400", "401", "403", "404", "406"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.WSErrorCommonData, http_res)
            raise errors.WSErrorCommon(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.EgainDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.EgainDefaultError("Unexpected response received", http_res)
