"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .articleattachment import ArticleAttachment, ArticleAttachmentTypedDict
from .articletype import ArticleType, ArticleTypeTypedDict
from .bookmarkstatus import BookmarkStatus, BookmarkStatusTypedDict
from .complianceforarticle import ComplianceForArticle, ComplianceForArticleTypedDict
from .createdby import CreatedBy, CreatedByTypedDict
from .customattribute import CustomAttribute, CustomAttributeTypedDict
from .edition import Edition, EditionTypedDict
from .languagecode import LanguageCode
from .link import Link, LinkTypedDict
from .modifiedby import ModifiedBy, ModifiedByTypedDict
from .ownedby import OwnedBy, OwnedByTypedDict
from .personalization import Personalization, PersonalizationTypedDict
from .structuredauthoringfields import (
    StructuredAuthoringFields,
    StructuredAuthoringFieldsTypedDict,
)
from .topicbreadcrumb import TopicBreadcrumb, TopicBreadcrumbTypedDict
from .workflow import Workflow, WorkflowTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ArticleTypedDict(TypedDict):
    r"""Success"""

    id: str
    r"""The ID of the Article.<br>An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    created_by: CreatedByTypedDict
    name: str
    r"""The name of the Article."""
    topic_breadcrumb: List[TopicBreadcrumbTypedDict]
    r"""A list of topics from the root topic to this Article. There may be multiple paths."""
    additional_info: NotRequired[str]
    r"""Additional information about the Article. Max 1 KB."""
    article_macro: NotRequired[str]
    r"""The name of the macro associated with this Article."""
    article_type: NotRequired[ArticleTypeTypedDict]
    r"""The type of the Article and its attributes."""
    article_keywords: NotRequired[str]
    r"""A comma-separated list of keywords associated with this Article. 1 KB max size limit."""
    article_summary: NotRequired[str]
    r"""A brief summary of the Article, provided as metadata. 1 KB max size limit."""
    attachments: NotRequired[List[ArticleAttachmentTypedDict]]
    r"""The attachments of the Article.

    """
    availability_date: NotRequired[str]
    r"""The date on which the Article version is available."""
    available_editions: NotRequired[List[EditionTypedDict]]
    r"""The editions of this Article that are available to the user."""
    average_rating: NotRequired[float]
    r"""The average rating of the Article."""
    content: NotRequired[str]
    r"""The Article content. The maximum allowed Article content size is 5 MB."""
    content_text: NotRequired[str]
    r"""The plaintext version of the Article content, which does not have the HTML tags and rich formatting present in *content*. The maximum allowed Article content size is 5 MB."""
    modified_by: NotRequired[ModifiedByTypedDict]
    owned_by: NotRequired[OwnedByTypedDict]
    created_date: NotRequired[str]
    custom_attributes: NotRequired[List[CustomAttributeTypedDict]]
    r"""A list of custom attributes."""
    department_id: NotRequired[str]
    r"""ID of the Article's department."""
    description: NotRequired[str]
    r"""A description of the Article. The maximum allowed Article description size is 1 KB."""
    expiration_date: NotRequired[str]
    r"""Date of Article expiration if Article expires otherwise empty."""
    image_url: NotRequired[str]
    r"""The URL of an image to be associated with the Article."""
    include_in_gen_ai: NotRequired[bool]
    r"""Indicates whether the Article is included for Generative AI."""
    is_subscribed: NotRequired[bool]
    r"""Indicates whether the Article is subscribed for notifications."""
    modified_date: NotRequired[str]
    r"""The date on which the Article was last modified."""
    language_code: NotRequired[LanguageCode]
    r"""Language code of the resource's language."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""
    structured_authoring_fields: NotRequired[StructuredAuthoringFieldsTypedDict]
    article_state: NotRequired[str]
    r"""The Article's state."""
    times_rated: NotRequired[int]
    r"""The number of times that this Article has been rated."""
    version_id: NotRequired[str]
    r"""The ID of this version of the Article."""
    workflow: NotRequired[WorkflowTypedDict]
    r"""The Article's workflow."""
    compliance: NotRequired[ComplianceForArticleTypedDict]
    r"""This schema contains the compliance details for an Article."""
    personalization: NotRequired[PersonalizationTypedDict]
    r"""Personalization allows the filtering of search results and controls the access to articles and article editions."""
    bookmark_status: NotRequired[BookmarkStatusTypedDict]
    r"""Article Bookmark Status"""


class Article(BaseModel):
    r"""Success"""

    id: str
    r"""The ID of the Article.<br>An Article ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    created_by: Annotated[CreatedBy, pydantic.Field(alias="createdBy")]

    name: str
    r"""The name of the Article."""

    topic_breadcrumb: Annotated[
        List[TopicBreadcrumb], pydantic.Field(alias="topicBreadcrumb")
    ]
    r"""A list of topics from the root topic to this Article. There may be multiple paths."""

    additional_info: Annotated[
        Optional[str], pydantic.Field(alias="additionalInfo")
    ] = None
    r"""Additional information about the Article. Max 1 KB."""

    article_macro: Annotated[Optional[str], pydantic.Field(alias="articleMacro")] = None
    r"""The name of the macro associated with this Article."""

    article_type: Annotated[
        Optional[ArticleType], pydantic.Field(alias="articleType")
    ] = None
    r"""The type of the Article and its attributes."""

    article_keywords: Annotated[
        Optional[str], pydantic.Field(alias="articleKeywords")
    ] = None
    r"""A comma-separated list of keywords associated with this Article. 1 KB max size limit."""

    article_summary: Annotated[
        Optional[str], pydantic.Field(alias="articleSummary")
    ] = None
    r"""A brief summary of the Article, provided as metadata. 1 KB max size limit."""

    attachments: Optional[List[ArticleAttachment]] = None
    r"""The attachments of the Article.

    """

    availability_date: Annotated[
        Optional[str], pydantic.Field(alias="availabilityDate")
    ] = None
    r"""The date on which the Article version is available."""

    available_editions: Annotated[
        Optional[List[Edition]], pydantic.Field(alias="availableEditions")
    ] = None
    r"""The editions of this Article that are available to the user."""

    average_rating: Annotated[
        Optional[float], pydantic.Field(alias="averageRating")
    ] = None
    r"""The average rating of the Article."""

    content: Optional[str] = None
    r"""The Article content. The maximum allowed Article content size is 5 MB."""

    content_text: Annotated[Optional[str], pydantic.Field(alias="contentText")] = None
    r"""The plaintext version of the Article content, which does not have the HTML tags and rich formatting present in *content*. The maximum allowed Article content size is 5 MB."""

    modified_by: Annotated[Optional[ModifiedBy], pydantic.Field(alias="modifiedBy")] = (
        None
    )

    owned_by: Annotated[Optional[OwnedBy], pydantic.Field(alias="ownedBy")] = None

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None

    custom_attributes: Annotated[
        Optional[List[CustomAttribute]], pydantic.Field(alias="customAttributes")
    ] = None
    r"""A list of custom attributes."""

    department_id: Annotated[Optional[str], pydantic.Field(alias="departmentID")] = None
    r"""ID of the Article's department."""

    description: Optional[str] = None
    r"""A description of the Article. The maximum allowed Article description size is 1 KB."""

    expiration_date: Annotated[
        Optional[str], pydantic.Field(alias="expirationDate")
    ] = None
    r"""Date of Article expiration if Article expires otherwise empty."""

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageURL")] = None
    r"""The URL of an image to be associated with the Article."""

    include_in_gen_ai: Annotated[
        Optional[bool], pydantic.Field(alias="includeInGenAI")
    ] = None
    r"""Indicates whether the Article is included for Generative AI."""

    is_subscribed: Annotated[Optional[bool], pydantic.Field(alias="isSubscribed")] = (
        None
    )
    r"""Indicates whether the Article is subscribed for notifications."""

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None
    r"""The date on which the Article was last modified."""

    language_code: Annotated[
        Optional[LanguageCode], pydantic.Field(alias="languageCode")
    ] = None
    r"""Language code of the resource's language."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""

    structured_authoring_fields: Annotated[
        Optional[StructuredAuthoringFields],
        pydantic.Field(alias="structuredAuthoringFields"),
    ] = None

    article_state: Annotated[Optional[str], pydantic.Field(alias="articleState")] = None
    r"""The Article's state."""

    times_rated: Annotated[Optional[int], pydantic.Field(alias="timesRated")] = None
    r"""The number of times that this Article has been rated."""

    version_id: Annotated[Optional[str], pydantic.Field(alias="versionId")] = None
    r"""The ID of this version of the Article."""

    workflow: Optional[Workflow] = None
    r"""The Article's workflow."""

    compliance: Optional[ComplianceForArticle] = None
    r"""This schema contains the compliance details for an Article."""

    personalization: Optional[Personalization] = None
    r"""Personalization allows the filtering of search results and controls the access to articles and article editions."""

    bookmark_status: Annotated[
        Optional[BookmarkStatus], pydantic.Field(alias="bookmarkStatus")
    ] = None
    r"""Article Bookmark Status"""
