"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .suggestionadditionalattributes import SuggestionAdditionalAttributes
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSuggestionRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    suggestion_id: str
    r"""The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    suggestion_additional_attributes: NotRequired[List[SuggestionAdditionalAttributes]]
    r"""The attributes of a Suggestion to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.

    #### Default Attributes
    These Suggestion attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the Suggestion.
    | name  | The name of the Suggestion.
    | status | The status of the Suggestion.
    | description | The description of the Suggestion.
    | language | Details about the language of the Suggestion.
    | modifiedBy.id | The ID of the user that last modified the Suggestion.
    | modifiedBy.firstName | The Suggestion's last modified user's first name.
    | modifiedBy.middleName | The Suggestion's last modified user's middle name.
    | modifiedBy.lastName | The Suggestion's last modified user's last name.
    | modifiedDate | The Suggestion's last modified date <u>and</u> information about the user that last modified the Suggestion.
    | link | The link object, used to retrieve the details of the Suggestion.
    | hasComments | The Suggestion has one or more comments
    | hasAttachments | The Suggestion has one or more attachments
    | hasRelatedArticles | The Suggestion has related articles

    """
    custom_additional_attributes: NotRequired[str]


class GetSuggestionRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    suggestion_id: Annotated[
        str,
        pydantic.Field(alias="suggestionID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the Suggestion.<br><br>A Suggestion ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    suggestion_additional_attributes: Annotated[
        Optional[List[SuggestionAdditionalAttributes]],
        pydantic.Field(alias="suggestionAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The attributes of a Suggestion to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' returns all attributes.

    #### Default Attributes
    These Suggestion attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the Suggestion.
    | name  | The name of the Suggestion.
    | status | The status of the Suggestion.
    | description | The description of the Suggestion.
    | language | Details about the language of the Suggestion.
    | modifiedBy.id | The ID of the user that last modified the Suggestion.
    | modifiedBy.firstName | The Suggestion's last modified user's first name.
    | modifiedBy.middleName | The Suggestion's last modified user's middle name.
    | modifiedBy.lastName | The Suggestion's last modified user's last name.
    | modifiedDate | The Suggestion's last modified date <u>and</u> information about the user that last modified the Suggestion.
    | link | The link object, used to retrieve the details of the Suggestion.
    | hasComments | The Suggestion has one or more comments
    | hasAttachments | The Suggestion has one or more attachments
    | hasRelatedArticles | The Suggestion has related articles

    """

    custom_additional_attributes: Annotated[
        Optional[str],
        pydantic.Field(alias="$customAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
