"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from egain_api_python.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ArticleCategories = Literal[
    "searchable",
    "all",
]
r"""Category of articles to return. All includes browsable and searchable."""


KnowledgeExportCode = Literal[
    "en-US",
    "es-ES",
    "fr-FR",
    "it-IT",
    "de-DE",
    "nl-NL",
    "pt-BR",
    "pt-PT",
    "da-DK",
    "ru-RU",
    "fr-CA",
    "zh-CN",
    "ja-JP",
    "ko-KR",
    "sv-SE",
]
r"""The code of the language."""


class KnowledgeExportLanguageTypedDict(TypedDict):
    r"""The Knowledge Base language in which the content is created."""

    code: KnowledgeExportCode
    r"""The code of the language."""


class KnowledgeExportLanguage(BaseModel):
    r"""The Knowledge Base language in which the content is created."""

    code: KnowledgeExportCode
    r"""The code of the language."""


ResourceType = Literal[
    "articles",
    "topics",
    "portals",
    "all",
]


DestinationType = Literal[
    "AWS S3 bucket",
    "Shared file path",
]
r"""Type of data destination"""


class KnowledgeExportCredentialsTypedDict(TypedDict):
    access_key: NotRequired[str]
    secret_key: NotRequired[str]


class KnowledgeExportCredentials(BaseModel):
    access_key: Annotated[Optional[str], pydantic.Field(alias="accessKey")] = None

    secret_key: Annotated[Optional[str], pydantic.Field(alias="secretKey")] = None


class DataDestinationTypedDict(TypedDict):
    destination_type: DestinationType
    r"""Type of data destination"""
    path: str
    r"""Path of the data destination"""
    region: NotRequired[str]
    r"""Region of the data destination"""
    credentials: NotRequired[KnowledgeExportCredentialsTypedDict]


class DataDestination(BaseModel):
    destination_type: Annotated[
        DestinationType, pydantic.Field(alias="destinationType")
    ]
    r"""Type of data destination"""

    path: str
    r"""Path of the data destination"""

    region: Optional[str] = None
    r"""Region of the data destination"""

    credentials: Optional[KnowledgeExportCredentials] = None


class KnowledgeExportTypedDict(TypedDict):
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    language: KnowledgeExportLanguageTypedDict
    r"""The Knowledge Base language in which the content is created."""
    resource_types: List[ResourceType]
    r"""Types of Knowledge Hub resources to export. Multiple values can be specified using a comma-separated list. Details of a single portal are exported.
    Articles whose state is Published are returned.
    | Portal Attribute Name | Description
    | ------------------------------- | -----------
    | id | The ID of the Portal in Readable format.
    | alternateId | The system-generated ID of the Portal in long format.
    | name  | The name of the Portal.
    | description | The Portal's description.
    | departmentId | ID of the department this Portal belongs to.
    | defaultContentLanguageId | The default ID of the language for the portal content.

    | Topic Attribute Name | Description
    | ------------------------------ | -----------
    | id | The ID of the Topic in Readable form.
    | alternateId | The system-generated ID of the Topic in long form.
    | name  | The name of the Topic.
    | departmentId | ID of the department this Topic belongs to.
    | modifiedDate | The date when the Topic was last modified on.
    | topicHomeArticleId | The ID of the Article used as the home page of this Topic.
    | childCount | Total number of children sub-topis below the current Topic.
    | subTopicIds | Array with the list of sub-topics (all levels of the topic hierarchy).
    | parentTopicId | ID of the parent Topic. -1 if it is the root Topic.
    | imageURL | URL of the inline Topic image.
    | customAttributes | One or more comma-separated names for Topic custom attributes defined by the user to be returned.

    | Article Attribute Name | Description
    | ---------------------- | -----------
    | id | The ID of the Article in Readable form.
    | alternateId | The system-generated ID of the Article in long form.
    | name  | The name of the Article.
    | additionalInfo | Additional information provided as Article metadata.
    | type | The Article type object and its attributes.
    | keywords | A comma-separated list of keywords associated with this Article, provided as metadata.
    | summary | A brief summary of the Article, provided as metadata.
    | state | The state of the Article. State P (Published).
    | departmentId | ID of the department this Article belongs to.
    | description | The description of the Article.
    | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article.
    | attachements | The Article's uploaded attachments and their IDs.
    | includeInGenAI  | Indicates whether this Article is used for eGain's generative AI features.
    | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths.
    | versionId | The ID of the Article version that is returned.
    | expirationDate | The date that the Article is set to expire.
    | averageRating | Average rating of the Article.
    | timesRated | Number or times the Article was rated.
    | availabilityDate | The date the Article is set to be available.
    | articleMacro | The macro of the Article.
    | content | path to the Article content in .html format.
    | customAttributes | One or more comma-separated names for Article custom attributes defined by the user to be returned.
    | personalization | Article personalization details, incuding tag categories.
    | editions | The editions of the Article, including the publish profile (view) associated with each edition.

    """
    data_destination: DataDestinationTypedDict
    article_categories: NotRequired[ArticleCategories]
    r"""Category of articles to return. All includes browsable and searchable."""


class KnowledgeExport(BaseModel):
    portal_id: Annotated[str, pydantic.Field(alias="portalID")]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    language: KnowledgeExportLanguage
    r"""The Knowledge Base language in which the content is created."""

    resource_types: Annotated[List[ResourceType], pydantic.Field(alias="resourceTypes")]
    r"""Types of Knowledge Hub resources to export. Multiple values can be specified using a comma-separated list. Details of a single portal are exported.
    Articles whose state is Published are returned.
    | Portal Attribute Name | Description
    | ------------------------------- | -----------
    | id | The ID of the Portal in Readable format.
    | alternateId | The system-generated ID of the Portal in long format.
    | name  | The name of the Portal.
    | description | The Portal's description.
    | departmentId | ID of the department this Portal belongs to.
    | defaultContentLanguageId | The default ID of the language for the portal content.

    | Topic Attribute Name | Description
    | ------------------------------ | -----------
    | id | The ID of the Topic in Readable form.
    | alternateId | The system-generated ID of the Topic in long form.
    | name  | The name of the Topic.
    | departmentId | ID of the department this Topic belongs to.
    | modifiedDate | The date when the Topic was last modified on.
    | topicHomeArticleId | The ID of the Article used as the home page of this Topic.
    | childCount | Total number of children sub-topis below the current Topic.
    | subTopicIds | Array with the list of sub-topics (all levels of the topic hierarchy).
    | parentTopicId | ID of the parent Topic. -1 if it is the root Topic.
    | imageURL | URL of the inline Topic image.
    | customAttributes | One or more comma-separated names for Topic custom attributes defined by the user to be returned.

    | Article Attribute Name | Description
    | ---------------------- | -----------
    | id | The ID of the Article in Readable form.
    | alternateId | The system-generated ID of the Article in long form.
    | name  | The name of the Article.
    | additionalInfo | Additional information provided as Article metadata.
    | type | The Article type object and its attributes.
    | keywords | A comma-separated list of keywords associated with this Article, provided as metadata.
    | summary | A brief summary of the Article, provided as metadata.
    | state | The state of the Article. State P (Published).
    | departmentId | ID of the department this Article belongs to.
    | description | The description of the Article.
    | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article.
    | attachements | The Article's uploaded attachments and their IDs.
    | includeInGenAI  | Indicates whether this Article is used for eGain's generative AI features.
    | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths.
    | versionId | The ID of the Article version that is returned.
    | expirationDate | The date that the Article is set to expire.
    | averageRating | Average rating of the Article.
    | timesRated | Number or times the Article was rated.
    | availabilityDate | The date the Article is set to be available.
    | articleMacro | The macro of the Article.
    | content | path to the Article content in .html format.
    | customAttributes | One or more comma-separated names for Article custom attributes defined by the user to be returned.
    | personalization | Article personalization details, incuding tag categories.
    | editions | The editions of the Article, including the publish profile (view) associated with each edition.

    """

    data_destination: Annotated[
        DataDestination, pydantic.Field(alias="dataDestination")
    ]

    article_categories: Annotated[
        Optional[ArticleCategories], pydantic.Field(alias="articleCategories")
    ] = "searchable"
    r"""Category of articles to return. All includes browsable and searchable."""
