"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .link import Link, LinkTypedDict
from egain_api_python.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SuggestionAttachmentTypedDict(TypedDict):
    r"""This schema contains the definition of an Attachment."""

    id: NotRequired[str]
    r"""The ID of the Attachment."""
    link: NotRequired[LinkTypedDict]
    r"""Defines the relationship between this resource and another object."""
    file_name: NotRequired[str]
    r"""The name of the Attachment file.<li>This must not exceed 255 characters.</li>"""
    size: NotRequired[int]
    r"""The size of the Attachment.<li>Limited to 25MB.</li>"""
    content_url: NotRequired[str]
    r"""The content URL of the Attachment. Download immediately, as this unique URL exists temporarily and can only be retrieved once before deletion.

    """


class SuggestionAttachment(BaseModel):
    r"""This schema contains the definition of an Attachment."""

    id: Optional[str] = None
    r"""The ID of the Attachment."""

    link: Optional[Link] = None
    r"""Defines the relationship between this resource and another object."""

    file_name: Annotated[Optional[str], pydantic.Field(alias="fileName")] = None
    r"""The name of the Attachment file.<li>This must not exceed 255 characters.</li>"""

    size: Optional[int] = None
    r"""The size of the Attachment.<li>Limited to 25MB.</li>"""

    content_url: Annotated[Optional[str], pydantic.Field(alias="contentUrl")] = None
    r"""The content URL of the Attachment. Download immediately, as this unique URL exists temporarily and can only be retrieved once before deletion.

    """
