"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from egain_api_python.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ExportStatusStatus = Literal[
    "Pending",
    "In Progress",
    "Successful",
    "Failed",
]


class ExportStatusProgressTypedDict(TypedDict):
    r"""Details about the job's progress."""

    processed: NotRequired[int]
    r"""The number of items processed so far."""
    total: NotRequired[int]
    r"""The total number of items to process."""
    percentage: NotRequired[float]
    r"""The percentage of the job that is complete."""


class ExportStatusProgress(BaseModel):
    r"""Details about the job's progress."""

    processed: Optional[int] = None
    r"""The number of items processed so far."""

    total: Optional[int] = None
    r"""The total number of items to process."""

    percentage: Optional[float] = None
    r"""The percentage of the job that is complete."""


class ExportStatusResultsTypedDict(TypedDict):
    r"""Breakdown of completed job results."""

    successful: NotRequired[int]
    r"""The count of successfully processed items."""
    warnings: NotRequired[int]
    r"""The count of items with warnings."""
    errors: NotRequired[int]
    r"""The count of items with errors."""


class ExportStatusResults(BaseModel):
    r"""Breakdown of completed job results."""

    successful: Optional[int] = None
    r"""The count of successfully processed items."""

    warnings: Optional[int] = None
    r"""The count of items with warnings."""

    errors: Optional[int] = None
    r"""The count of items with errors."""


class ExportStatusTypedDict(TypedDict):
    status: ExportStatusStatus
    progress: NotRequired[ExportStatusProgressTypedDict]
    r"""Details about the job's progress."""
    start_time: NotRequired[datetime]
    r"""The timestamp when the job started."""
    estimated_completion: NotRequired[datetime]
    r"""The estimated timestamp when the job is expected to finish."""
    completion_time: NotRequired[datetime]
    r"""The timestamp when the job completed."""
    failure_time: NotRequired[datetime]
    r"""The timestamp when the job failed."""
    results: NotRequired[ExportStatusResultsTypedDict]
    r"""Breakdown of completed job results."""
    error: NotRequired[str]
    r"""A description of the job failure reason."""


class ExportStatus(BaseModel):
    status: ExportStatusStatus

    progress: Optional[ExportStatusProgress] = None
    r"""Details about the job's progress."""

    start_time: Annotated[Optional[datetime], pydantic.Field(alias="startTime")] = None
    r"""The timestamp when the job started."""

    estimated_completion: Annotated[
        Optional[datetime], pydantic.Field(alias="estimatedCompletion")
    ] = None
    r"""The estimated timestamp when the job is expected to finish."""

    completion_time: Annotated[
        Optional[datetime], pydantic.Field(alias="completionTime")
    ] = None
    r"""The timestamp when the job completed."""

    failure_time: Annotated[Optional[datetime], pydantic.Field(alias="failureTime")] = (
        None
    )
    r"""The timestamp when the job failed."""

    results: Optional[ExportStatusResults] = None
    r"""Breakdown of completed job results."""

    error: Optional[str] = None
    r"""A description of the job failure reason."""
