"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .acceptlanguage import AcceptLanguage
from .articleadditionalattributes import ArticleAdditionalAttributes
from .languagequeryparameter import LanguageQueryParameter
from .workflowmilestone import WorkflowMilestone
from egain_api_python.types import BaseModel
from egain_api_python.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


AccessSource = Literal[
    "article_view",
    "article_view_more_related_Article",
    "article_view_basic_search",
    "article_view_adv_search",
    "article_view_guided_help",
    "article_view_browse_topic",
    "article_view_browse_tree",
    "article_view_popular_articles",
    "article_view_useful_items",
    "article_view_widget",
    "article_view_announcement",
    "article_view_bookmarked",
    "article_view_subscription_notification",
    "article_view_guided_help_additional_info",
    "view_articles_pending_compliance",
    "type_ahead_Suggestion",
    "semantic_Suggestion",
    "instant_answer",
    "instant_answer_reference",
]
r"""Provides information about the method in which the Article is accessed and is used for self-service analytics. Refer to the eGain User Guide regarding \"Article View Contexts\".

| Name | Description
| ---- | -----------
| article_view | View an Article directly using its ID.
| article_view_more_related_Article  | View related articles of an Article using its ID.
| article_view_basic_search | View an Article via a basic search.
| article_view_adv_search | View an Article via an advanced search.
| article_view_guided_help | View an Article via a Guided Help solution.
| article_view_browse_topic | View an Article via browsing a topic.
| article_view_browse_tree | View an Article via browsing a topic tree.
| article_view_popular_articles | View an Article using the Popular Items list in the Self-Service portal.
| article_view_useful_items | View Article using the Useful Items list in the Self-Service portal.
| article_view_widget | View an Article via a widget.
| article_view_announcement | View an Article from the announcement section in the Self-Service portal.
| article_view_bookmarked | View a bookmarked Article.
| article_view_subscription_notification | View an Article from a subscription notification.
| article_view_guided_help_additional_info | View an Article via additional information from a Guided Help search.
| view_articles_pending_compliance | View an Article via Read & Sign in the Self-Service portal.
| type_ahead_Suggestion | View an Article from a type-ahead Suggestion in the Self-Service portal.
| semantic_Suggestion | View an Article from a semantic Suggestion in the Self-Service portal.
| instant_answer | View an Article via an Instant Answers solution.
| instant_answer_reference | View an Article that is used as a reference for an Instant Answers solution.

"""


class GetArticleByIDRequestTypedDict(TypedDict):
    accept_language: AcceptLanguage
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""
    portal_id: str
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""
    article_id: str
    r"""The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits."""
    language: NotRequired[LanguageQueryParameter]
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>"""
    article_additional_attributes: NotRequired[List[ArticleAdditionalAttributes]]
    r"""The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.

    #### Default Attributes
    These Article attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the Article.
    | name  | The name of the Article.
    | additionalInfo | Additional information provided as Article metadata.
    | articleType | The Article type and its attributes.
    | articleKeywords | A comma-separated list of keywords associated with this Article.
    | articleState | The current state of the Article. States include A (Authoring), S (Staging), and P (Published).
    | articleSummary | A brief summary of the Article, provided as metadata.
    | createdBy | The ID, first name, middle name and last name of the user that created the Article.
    | createdDate | The date that the Article was created.
    | departmentId | ID of the department for which this Article belongs to.
    | description | The Article's description.
    | expirationDate | The date that the Article is set to expire.
    | attachments | The Article's attachments
    | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article.
    | includeInGenAI | Indicates whether this Article is used for eGain's generative AI features.
    | isSubscribed | Indicates whether the Article is subscribed for notifications.
    | languageCode | The language code of the Article language.
    | link | The link object, used to retrieve the details of the Article.
    | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article.
    | modifiedDate | The date that the Article was last modified on.
    | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths.
    | versionId | The ID of the Article version that is returned.

    """
    custom_additional_attributes: NotRequired[str]
    access_source: NotRequired[AccessSource]
    r"""Provides information about the method in which the Article is accessed and is used for self-service analytics. Refer to the eGain User Guide regarding \"Article View Contexts\".

    | Name | Description
    | ---- | -----------
    | article_view | View an Article directly using its ID.
    | article_view_more_related_Article  | View related articles of an Article using its ID.
    | article_view_basic_search | View an Article via a basic search.
    | article_view_adv_search | View an Article via an advanced search.
    | article_view_guided_help | View an Article via a Guided Help solution.
    | article_view_browse_topic | View an Article via browsing a topic.
    | article_view_browse_tree | View an Article via browsing a topic tree.
    | article_view_popular_articles | View an Article using the Popular Items list in the Self-Service portal.
    | article_view_useful_items | View Article using the Useful Items list in the Self-Service portal.
    | article_view_widget | View an Article via a widget.
    | article_view_announcement | View an Article from the announcement section in the Self-Service portal.
    | article_view_bookmarked | View a bookmarked Article.
    | article_view_subscription_notification | View an Article from a subscription notification.
    | article_view_guided_help_additional_info | View an Article via additional information from a Guided Help search.
    | view_articles_pending_compliance | View an Article via Read & Sign in the Self-Service portal.
    | type_ahead_Suggestion | View an Article from a type-ahead Suggestion in the Self-Service portal.
    | semantic_Suggestion | View an Article from a semantic Suggestion in the Self-Service portal.
    | instant_answer | View an Article via an Instant Answers solution.
    | instant_answer_reference | View an Article that is used as a reference for an Instant Answers solution.

    """
    publish_view_id: NotRequired[str]
    r"""The ID of a publish view for an Article. A publish view is a set of tags used to generate multiple editions of the same Article for display on the self-service portal. Publish views are used in conjunction with single sourcing to tailor the content of an Article to a specific audience by granting access to an Article's version to users that possess the same tags.<br><br>A publish view ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits."""
    workflow_milestone: NotRequired[WorkflowMilestone]
    r"""For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>"""


class GetArticleByIDRequest(BaseModel):
    accept_language: Annotated[
        AcceptLanguage,
        pydantic.Field(alias="Accept-Language"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""The Language locale accepted by the client (used for locale specific fields in resource representation and in error responses)."""

    portal_id: Annotated[
        str,
        pydantic.Field(alias="portalID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the portal being accessed.<br><br>A portal ID is composed of a 2-4 letter prefix, followed by a dash and 4-15 digits."""

    article_id: Annotated[
        str,
        pydantic.Field(alias="articleID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the Article.<br><br>An Article ID is composed of a 2-4 letter prefix followed by a dash and 4-15 digits."""

    language: Annotated[
        Optional[LanguageQueryParameter],
        pydantic.Field(alias="$lang"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The language that describes the details of a resource. Resources available in different languages may differ from each other.<li>If <code>lang</code> is not passed, then the portal's default language is used.</li>"""

    article_additional_attributes: Annotated[
        Optional[List[ArticleAdditionalAttributes]],
        pydantic.Field(alias="articleAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""The attributes of an Article to be returned *in addition to* the default list of attributes, listed below. Multiple additional attributes can be specified using a comma-separated list. Passing 'all' will return all attributes.

    #### Default Attributes
    These Article attributes are always returned:

    | Name | Description
    | ---- | -----------
    | id | The ID of the Article.
    | name  | The name of the Article.
    | additionalInfo | Additional information provided as Article metadata.
    | articleType | The Article type and its attributes.
    | articleKeywords | A comma-separated list of keywords associated with this Article.
    | articleState | The current state of the Article. States include A (Authoring), S (Staging), and P (Published).
    | articleSummary | A brief summary of the Article, provided as metadata.
    | createdBy | The ID, first name, middle name and last name of the user that created the Article.
    | createdDate | The date that the Article was created.
    | departmentId | ID of the department for which this Article belongs to.
    | description | The Article's description.
    | expirationDate | The date that the Article is set to expire.
    | attachments | The Article's attachments
    | imageURL | The URL of the image that is present in the Article version. It is used as the thumbnail image for the Article.
    | includeInGenAI | Indicates whether this Article is used for eGain's generative AI features.
    | isSubscribed | Indicates whether the Article is subscribed for notifications.
    | languageCode | The language code of the Article language.
    | link | The link object, used to retrieve the details of the Article.
    | modifiedBy | The ID, first name, middle name and last name of the user that last modified the Article.
    | modifiedDate | The date that the Article was last modified on.
    | topicBreadcrumb | Contains a list of topics from the top-level topic to this Article. There may be multiple paths.
    | versionId | The ID of the Article version that is returned.

    """

    custom_additional_attributes: Annotated[
        Optional[str],
        pydantic.Field(alias="$customAdditionalAttributes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    access_source: Annotated[
        Optional[AccessSource],
        pydantic.Field(alias="accessSource"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "article_view"
    r"""Provides information about the method in which the Article is accessed and is used for self-service analytics. Refer to the eGain User Guide regarding \"Article View Contexts\".

    | Name | Description
    | ---- | -----------
    | article_view | View an Article directly using its ID.
    | article_view_more_related_Article  | View related articles of an Article using its ID.
    | article_view_basic_search | View an Article via a basic search.
    | article_view_adv_search | View an Article via an advanced search.
    | article_view_guided_help | View an Article via a Guided Help solution.
    | article_view_browse_topic | View an Article via browsing a topic.
    | article_view_browse_tree | View an Article via browsing a topic tree.
    | article_view_popular_articles | View an Article using the Popular Items list in the Self-Service portal.
    | article_view_useful_items | View Article using the Useful Items list in the Self-Service portal.
    | article_view_widget | View an Article via a widget.
    | article_view_announcement | View an Article from the announcement section in the Self-Service portal.
    | article_view_bookmarked | View a bookmarked Article.
    | article_view_subscription_notification | View an Article from a subscription notification.
    | article_view_guided_help_additional_info | View an Article via additional information from a Guided Help search.
    | view_articles_pending_compliance | View an Article via Read & Sign in the Self-Service portal.
    | type_ahead_Suggestion | View an Article from a type-ahead Suggestion in the Self-Service portal.
    | semantic_Suggestion | View an Article from a semantic Suggestion in the Self-Service portal.
    | instant_answer | View an Article via an Instant Answers solution.
    | instant_answer_reference | View an Article that is used as a reference for an Instant Answers solution.

    """

    publish_view_id: Annotated[
        Optional[str],
        pydantic.Field(alias="publishViewId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of a publish view for an Article. A publish view is a set of tags used to generate multiple editions of the same Article for display on the self-service portal. Publish views are used in conjunction with single sourcing to tailor the content of an Article to a specific audience by granting access to an Article's version to users that possess the same tags.<br><br>A publish view ID is composed of a 4-letter prefix, followed by a dash and 4-15 digits."""

    workflow_milestone: Annotated[
        Optional[WorkflowMilestone],
        pydantic.Field(alias="workflowMilestone"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""For agents with the View Author Portal or View Staging Portal actions, this determines which version of the Article is returned.<li>'Authoring' returns the most recent version of an Article checked-in by an author.</li><li>'Staging' returns the updated version currently being processed in a workflow.</li><li>'Publish' returns the most recently published version.</li>"""
